jQuery(document).ready(function ($) {

    // 工单列表逻辑
    var orderList = new Vue({
        el: '#order-list',
        data: {
            workOrders: []
        },
        methods: {
            woDetail: function (wo) {
                console.log(wo.id);
                // 获取工单详情
                var data = JSON.stringify(
                    {
                        "id": wo.id,
                        "woStatus": wo.woStatus,
                        "woType": wo.woType,
                        "woProcessUid": 1
                    }
                );
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        orderList.workOrders = res.data.list;
                        // 计算页数
                        if (Math.round(res.data.total % res.data.size) == 0) {
                            pager.totalPage = Math.round(res.data.total / res.data.size);
                        } else {
                            console.log(res.data.total / res.data.size);
                            pager.totalPage = Math.round(res.data.total / res.data.size) + 1;
                        }

                    },
                    fail: function (msg) {
                        console.log(msg);

                    }
                });

            }
        }
    })

    function initLoadWO() {
        var url = "/work/wo/list?page=1&limit=10";
        var data = JSON.stringify({
            "woStatus": 0,
            "woType": "revisit",
            "woProcessUid": 1
        });
        $.ajax({
            url: url,
            dataType: "json",
            data: data,
            type: 'post',
            contentType: "application/json; charset=utf-8",
            success: function (res) {
                console.log(res);
                orderList.workOrders = res.data.list;
                numCount.message = res.data.total;

                // 计算页数
                if (Math.round(res.data.total % res.data.size) == 0) {
                    pager.totalPage = Math.round(res.data.total / res.data.size);
                } else {
                    console.log(res.data.total / res.data.size);
                    pager.totalPage = Math.round(res.data.total / res.data.size) + 1;
                }
            }
        });
    }

    var host = "http://localhost:8083";

    // 初始化加载回访工单列表
    initLoadWO();

    // 员工工作状态逻辑
    var workStatus = new Vue({
        el: '#workStatus',
        selected: {},
        methods: {
            updateWOStatus: function (val) {
                console.log('updateWOStatus:' + val.target.value);
                var url = "/work/ws/update";
                var data = JSON.stringify({
                    "woStatus": val.target.value,
                    "statusDisplay": "",
                    "userId": 1
                });
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        console.log("用户状态修改成功！");
                    }
                });

            }
        },
        data: {
            woStates: [
                {value: 0, text: '空闲中'},
                {value: 1, text: '下班'},
                {value: 2, text: '挂起'},
                {value: 3, text: '接待中'},
                {value: 4, text: '会议中'},
                {value: 5, text: '午饭中'}
            ]
        }
    })


    // 数据提示条
    var numCount = new Vue({
        el: '#numCount',
        data: {
            message: "100"
        }
    })
    // 页面分页按钮逻辑
    var pager = new Vue({
        el: '#pager',
        data: {
            curPage: 1,
            totalPage: 1
        },
        methods: {
            prePage: function () {
                if (this.curPage - 1 < 1) {
                    return;
                } else {
                    this.curPage = this.curPage - 1;
                }
            },
            nextPage: function () {
                if (this.curPage + 1 > this.totalPage) {
                    return;
                } else {
                    this.curPage = this.curPage + 1;
                }
            }
        }
    })

    // 工单状态选择Tab逻辑
    var url = "/work/wo/list?page=1&limit=10";
    var statusTab = new Vue({
        el: '#statusTab',
        methods: {
            unprocessed: function () {
                var data = JSON.stringify(
                    {
                        "woStatus": 0,
                        "woType": "revisit",
                        "woProcessUid": 1
                    }
                );
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        orderList.workOrders = res.data.list;
                        // 计算页数
                        if (res.data.total % res.data.size == 0) {
                            pager.totalPage = Math.round(res.data.total / res.data.size);
                        } else {
                            console.log(res.data.total / res.data.size);
                            pager.totalPage = Math.round(res.data.total / res.data.size) + 1;
                        }
                    },
                    fail: function (msg) {
                        console.log("Error happened, Please contact Administrator. " + msg);

                    }
                });
            },
            processed: function () {
                var data = JSON.stringify(
                    {
                        "woStatus": 1,
                        "woType": "revisit",
                        "woProcessUid": 1
                    }
                );
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        orderList.workOrders = res.data.list;
                        // 计算页数
                        if (Math.round(res.data.total % res.data.size) == 0) {
                            pager.totalPage = Math.round(res.data.total / res.data.size);
                        } else {
                            console.log(res.data.total / res.data.size);
                            pager.totalPage = Math.round(res.data.total / res.data.size) + 1;
                        }
                    },
                    fail: function (msg) {
                        console.log(msg);

                    }
                });
            }
        }
    })

    // 将回访工单列表做页面渲染
    console.log('Finished.');

});
