$(document).ready(function () {
    if ($.cookie('SESSIONID')) {
        console.log("logined");
    } else {
        var ticket = getQueryString("ticket");
        if (!ticket) {
            window.location.href = "http://testcas.yidianling.com/login.html?url=" + window.location.href;
        } else {
            $.ajax({
                url: "/work/cas/validate/ticket/" + ticket,
                contentType: "application/json",
                xhrFields: {
                    withCredentials: true
                },
                async: false,
                method: "POST",
                crossDomain: true,
                success: function (data, status) {
                    if (data.code != 200) {
                        alert(data.msg);
                    } else {
                        console.log("success");
                        window.location.href = removedParameter(window.location.href, "ticket");
                    }
                }
            });
        }
    }
});

function removedParameter(url, ref) {

    // 如果不包括此参数
    if (url.indexOf(ref) == -1)
        return url;

    var arr_url = url.split('?');

    var base = arr_url[0];

    var arr_param = arr_url[1].split('&');

    var index = -1;

    for (i = 0; i < arr_param.length; i++) {

        var paired = arr_param[i].split('=');

        if (paired[0] == ref) {

            index = i;
            break;
        }
    }

    if (index == -1) {
        return url;
    } else {
        arr_param.splice(index, 1);
        return base + "?" + arr_param.join('&');
    }
}

function getQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) {
        return unescape(r[2]);
    }
    return null;
}

function logout(){
  $.ajax({
        url: "/work/cas/logout",
        contentType: "application/json",
        xhrFields: {
            withCredentials: true
        },
        async: false,
        method: "POST",
        crossDomain: true,
        success: function (data, status) {
            if (data.code != 200) {
                alert(data.msg);
            } else {
                console.log("success");
                window.location.reload();
            }
        }
    });
}