jQuery(document).ready(function ($) {
	
	var pageSize = 10
	var prePageSize
    // 工单列表逻辑
    var orderList = new Vue({
        el: '#order-list',
        data: {
            workOrders: []
        },
        methods: {
            woDetail: function (wo) {
                console.log(wo.id);
                // 获取工单详情
                window.location.href="/woDetail.html?id=" + wo.id;
            }

        }
    })

    function initLoadWO() {
		var url = "/work/wo/list?page=1&limit=" + pageSize;
        var data = JSON.stringify({
                "woStatus": 0,
                "woType": "revisit",
                "woProcessUid": 1
        });
        $.ajax({
            url: url,
            dataType: "json",
            data: data,
            type: 'post',
            contentType: "application/json; charset=utf-8",
            success: function (res) {
                console.log(res);
                orderList.workOrders = res.data.list;
                numCount.count = res.data.total;
                numCount.pageStart = 1;
                var curItems;
                if(res.data.size < pageSize){
                	curItems = res.data.size;
                } else {
                	curItems = pageSize;
                }
                numCount.pageEnd = curItems;
                pager.curPage = 1;
                // 计算页数
                pager.totalPage = Math.ceil(res.data.total / pageSize);
            }
        });
    }

    var host = "http://localhost:8083";

    // 初始化加载回访工单列表
    initLoadWO();

    // 员工工作状态逻辑
    var workStatus = new Vue({
        el: '#workStatus',
        selected: {},
        methods: {
            updateWOStatus: function (val) {
                console.log('updateWOStatus:' + val.target.value);
                var url = "/work/ws/update";
                var data = JSON.stringify({
                    "userStatus": val.target.value,
                    "statusDisplay": "",
                    "userId": 1
                });
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        console.log("用户状态修改成功！");
                    }
                });
            }
        },
        data: {
        	woStates: [
            	{value: 1, text: '空闲中'},
                {value: 2, text: '下班'},
                {value: 3, text: '接待中'},
                {value: 4, text: '会议中'},
                {value: 5, text: '短暂离开'}
            ]
        }
    })
   

    // 数据提示条
    var numCount = new Vue({
        el: '#numCount',
        data: {
        	count: "",
            pageStart:"",
            pageEnd:""
        }
    })
    // 页面分页按钮逻辑
    var pager = new Vue({
        el: '#pager',
        data: {
        	curPage: "",
            totalPage: ""
        },
        methods: {
            prePage: function () {
            	if (this.curPage - 1 < 1) {
                    return;
                } else {
                    this.curPage = this.curPage - 1;
                }
                
                var url = "/work/wo/list?page=" + this.curPage + "&limit=" + pageSize;
                var data = JSON.stringify({
                        "woStatus": 0,
                        "woType": "revisit",
                        "woProcessUid": 1
                    
                });
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        orderList.workOrders = res.data.list;
                        numCount.pageStart = numCount.pageStart - pageSize;
                        numCount.pageEnd = numCount.pageEnd - prePageSize;
                        prePageSize = res.data.size;
                    }
                });
            },
            nextPage: function () {
            	if (this.curPage + 1 > this.totalPage) {
                    return;
                } else {
                    this.curPage = this.curPage + 1;
                }
                
                var url = "/work/wo/list?page=" + this.curPage + "&limit=" + pageSize;
                var data = JSON.stringify({
                        "woStatus": 0,
                        "woType": "revisit",
                        "woProcessUid": 1
                    
                });
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        orderList.workOrders = res.data.list;
                        prePageSize = res.data.size;
                        numCount.pageStart = numCount.pageStart + pageSize;
                        
                        var curItems;
                        if(res.data.size < pageSize){
                        	curItems = res.data.size;
                        } else {
                        	curItems = pageSize;
                        }
                        // 计算页数
                        numCount.pageEnd = numCount.pageEnd + curItems;
                    }
                });
            }
        }
    })

    // 工单状态选择Tab逻辑
    var url = "/work/wo/list?page=1&limit=" + pageSize;
    var statusTab = new Vue({
        el: '#statusTab',
        methods: {
            unprocessed: function () {
                var data = JSON.stringify(
                    {
                        "woStatus": 0,
                        "woType": "revisit",
                        "woProcessUid": 1
                    }
                );
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        orderList.workOrders = res.data.list;
                        numCount.count = res.data.total;
                        numCount.pageStart = 1;
                        var curItems;
                        if(res.data.size < pageSize){
                        	curItems = res.data.size;
                        } else {
                        	curItems = pageSize;
                        }
                        numCount.pageEnd = curItems;
                        pager.curPage = 1;
                        // 计算页数
                        pager.totalPage = Math.ceil(res.data.total / pageSize);
                    },
                    fail: function (msg) {
                        console.log("Error happened, Please contact Administrator. " + msg);

                    }
                });
            },
            processed: function () {
                var data = JSON.stringify(
                    {
                        "woStatus": 1,
                        "woType": "revisit",
                        "woProcessUid": 1
                    }
                );
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        orderList.workOrders = res.data.list;
                        numCount.count = res.data.total;
                        numCount.pageStart = 1;
                        var curItems;
                        if(res.data.size < pageSize){
                        	curItems = res.data.size;
                        } else {
                        	curItems = pageSize;
                        }
                        pager.curPage = 1;
                        numCount.pageEnd = curItems;
                        // 计算页数
                        pager.totalPage = Math.ceil(res.data.total / pageSize);
                    },
                    fail: function (msg) {
                        console.log(msg);

                    }
                });
            }
        }
    })

});
