jQuery(document).ready(function ($) {

    // 工单列表逻辑
    var app = new Vue({
        el: '#app',
        data: {
            deptId: 0,
            addDeptId:0,
            woId:0,
            deptNames: [
                {value: 0, text: "请选择"},
                {value: 1, text: "好柿"},
                {value: 2, text: "心暖"},
                {value: 3, text: "电商"},
                {value: 4, text: "客服"}
            ],
            woId: '',
            operateName: '新增',
            displayForm: false,
            displayAuditTrace: false,
            addWoType: 0,
            woTypes: [
                {value: 0, text: "请选择"},
                {value: 1, text: "回访工单"}
            ],
            woTrueTypes: {
                "revisit": 1,
                "": 0
            },
            woTypeDB: {
                0: "",
                1: "revisit"
            },
            urgentLevels: [
                {value: 0, text: "请选择"},
                {value: 1, text: "一般"},
                {value: 2, text: "紧急"},
                {value: 3, text: "非常紧急"}
            ],
            addUrgentLevel:0,
            duringTimeHour: 2,
            duringTimeMin: 0,
            assignLimit: 20,
            remindTime: 5,
            sysCfgList: [],
            auditTraceList: [],
            sysCfgId: 0
        },
        mounted: function () {
            // 初始化加载回访工单列表
            var url = "/work/sysWoCfg/list?page=1&limit=10";
            var data = JSON.stringify({
                "woType": "revisit"
            });
            $.ajax({
                url: url,
                dataType: "json",
                data: data,
                type: 'post',
                contentType: "application/json; charset=utf-8",
                success: function (res) {
                    if (res.data) {
                        app.sysCfgList = res.data;
                    }
                }
            });
        },
        methods: {
            sysCfgDetail: function (sysCfg) {
                app.displayForm = true;
                app.displayAuditTrace = false;
                // 获取工单详情
                var data = JSON.stringify(
                    {
                        "id": sysCfg.id
                    }
                );
                var url = "/work/sysWoCfg/detail";
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        if (res.data) {
                            app.addWoType = app.woTrueTypes[res.data.woType];
                            app.addUrgentLevel = res.data.urgentLevel;
                            app.addDeptId = res.data.deptId;
                            var duringTime = res.data.duringTime;
                            if(duringTime % 60 != 0) {
                                app.duringTimeMin = duringTime % 60 ;
                            }
                            app.duringTimeHour = Math.floor(duringTime / 60);
                            app.assignLimit = parseInt(res.data.assignLimit);
                            app.remindTime = res.data.remindTime;
                            app.sysCfgId = res.data.id;
                            app.operateName = '编辑';
                        }

                    }
                });
            },
            querySysCfg: function () {
                console.log('querySysCfg: ' + app.deptId);
                console.log("woId: " + app.woId);
                var data = JSON.stringify(
                    {
                        "woId": app.woId,
                        "deptId": app.deptId,
                        "creator":1,
                        "creatorName":'sys',
                        "deptId": app.addDeptId,
                        "deptName": app.deptNames[app.addDeptId].text,
                        "duringTime": parseInt(app.duringTimeMin) + parseInt(app.duringTimeHour * 60),
                        "remindTime": app.remindTime,
                        "assignLimit": parseInt(app.assignLimit),
                        "urgentLevel":app.addUrgentLevel
                    }
                );


            },
            queryAuditTrace: function (sysCfg) {
                console.log('queryAuditTrace: ' + sysCfg.id);
                app.displayAuditTrace = true;
                app.displayForm = false;
            },
            addSysCfg: function () {
                app.displayForm = true;
                console.log('addSysCfg');
                app.operateName = '新增';

            },
            saveOrUpdateSysCfg: function () {
                console.log('saveOrUpdateSysCfg');
                var data = JSON.stringify(
                    {
                        "id": app.sysCfgId,
                        "woType": app.woTypeDB[app.addWoType],
                        "creator":1,
                        "creatorName":'sys',
                        "deptId": app.addDeptId,
                        "deptName": app.deptNames[app.addDeptId].text,
                        "duringTime": parseInt(app.duringTimeMin) + parseInt(app.duringTimeHour * 60),
                        "remindTime": app.remindTime,
                        "assignLimit": parseInt(app.assignLimit),
                        "urgentLevel":app.addUrgentLevel
                    }
                );
                console.log("Request data...");
                console.log(data);
                var url = "/work/sysWoCfg/saveOrUpdate";
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        app.displayForm = false;
                    }
                });
                // app.displayForm = true;
            }
        }
    })

    function initLoadWoSysConfig() {


    }

    initLoadWoSysConfig();
});
