jQuery(document).ready(function ($) {
	
	var auditTableName = "wo_work_order"
	var woType = "revisit"
    // 工单列表逻辑
    var woDetail = new Vue({
        el: '#woDetail',
        data: {
        	orderDetail:{
        		id: 0,
        		orderNum: 0,
        		doctorUid: 0,
        		doctorName: '',
        		processUid: 0,
        		processName: '',
        		phoneNum: '',
        		customerUid: 0,
        		customerName: '',

        		callStatus: 0,
                callRemark: '',
                smsStatus: 0,
                smsRemark: '',
                consultStatus: 0,
                consultRemark: '',
                assistStatus: 0,
                assistRemark: '',
                unpleasureStatus: 0,
                unpleasureEntity: 0,
                unpleasureDetail: '',
                unpleasureDeptName: [],
                unpleasureSolution: '',
                userAdvice: '',
                revisitStatus: 0,
                revisitRemark: ''
        	},
    
            callStates: [
                {value: 0, text: '请选择'},
                {value: 1, text: '督导'},
                {value: 2, text: '接通拒听'},
                {value: 3, text: '未接听'},
                {value: 4, text: '未接通拒绝'},
                {value: 5, text: '无法呼出'},
                {value: 6, text: '用户不便'},
                {value: 7, text: '助理添加标签'}
            ],
            smsStates: [
                {value: 0, text: '请选择'},
                {value: 1, text: '是'},
                {value: 2, text: '否'}
            ],
            consultStates: [
                {value: 0, text: '请选择'},
                {value: 1, text: '满意'},
                {value: 2, text: '一般'},
                {value: 3, text: '不满意'}
            ],
            assistStates: [
                {value: 0, text: '请选择'},
                {value: 1, text: '满意'},
                {value: 2, text: '一般'},
                {value: 3, text: '不满意'}
            ],
            unpleasureStates:[
                {value: 0, text: '请选择'},
                {value: 1, text: '未处理'},
                {value: 2, text: '处理中'},
                {value: 3, text: '已处理'}
            ],
            unpleasureEntities: [
                {value: 0, text: '请选择'},
                {value: 1, text: '咨询师'},
                {value: 2, text: '咨询师助理'},
                {value: 3, text: '平台'},
                {value: 4, text: '其他'}
            ],
            revisitStates: [
                {value: 0, text: '请选择'},
                {value: 1, text: '未回访'},
                {value: 2, text: '推迟回访'},
                {value: 3, text: '不回访'},
                {value: 4, text: '已回访'}
            ],
            auditDetails:[]

        },
        methods: {
            saveWODetail: function () {
                var url = "/work/wo/saveDetail";
                var urlParams = new URLSearchParams(window.location.search);
                var woId = urlParams.get('id');
                var data = JSON.stringify(
                    {
                    	"id":woDetail.orderDetail.id,
                        "customerName": woDetail.orderDetail.customerName,
                        "customerUid": woDetail.orderDetail.customerUid,
                        "doctorName": woDetail.orderDetail.doctorName,
                        "doctorUid": woDetail.orderDetail.doctorUid,
                        "orderNum": woDetail.orderDetail.orderNum,
                        "phoneNum": woDetail.orderDetail.phoneNum,
                        "processName": woDetail.orderDetail.processName,
                        "processUid": woDetail.orderDetail.processUid,
                        "callStatus": woDetail.orderDetail.callStatus,
                        "callRemark": woDetail.orderDetail.callRemark,
                        "smsRemark": woDetail.orderDetail.smsRemark,
                        "smsStatus": woDetail.orderDetail.smsStatus,
                        "consultStatus": woDetail.orderDetail.consultStatus,
                        "consultRemark": woDetail.orderDetail.consultRemark,
                        "assistStatus": woDetail.orderDetail.assistStatus,
                        "assistRemark": woDetail.orderDetail.assistRemark,
                        "unpleasureStatus": woDetail.orderDetail.unpleasureStatus,
                        "unpleasureDetail": woDetail.orderDetail.unpleasureDetail,
                        "unpleasureEntity": woDetail.orderDetail.unpleasureEntity,
                        "unpleasureDeptName": woDetail.orderDetail.unpleasureDeptName,
                        "unpleasureSolution": woDetail.orderDetail.unpleasureSolution,
                        "userAdvice": woDetail.orderDetail.userAdvice,
                        "revisitStatus": woDetail.orderDetail.revisitStatus,
                        "revisitRemark": woDetail.orderDetail.revisitRemark,
                        "woId": woId
                    }
                );
                console.log(data);
                $.ajax({
                    url: url,
                    dataType: "json",
                    data: data,
                    type: 'post',
                    contentType: "application/json; charset=utf-8",
                    success: function (res) {
                        console.log(res);
                        window.location.href = '/index.html'
                    }
                });
                
                var data = JSON.stringify(
                        {
                        	"id":woId,
                            "woProcessName": woDetail.orderDetail.processName,
                            "woProcessUid": woDetail.orderDetail.processUid,
                            "woType": woType,
                            "woStatus": 1,
                            "statusDisplay": "处理完成",
                            "orderNum": woDetail.orderDetail.orderNum
                        }
                    );
                    console.log(data);
                    $.ajax({
                        url: "/work/wo/update",
                        dataType: "json",
                        data: data,
                        type: 'post',
                        contentType: "application/json; charset=utf-8",
                        success: function (res) {
                            console.log(res);
                            window.location.href = '/index.html'
                        }
                    });
            },
            
            navigateToOrderList :function () {
            	window.location.href="/";
            }
        }
    })
	
    function initDetail() {
        var urlParams = new URLSearchParams(window.location.search);
        var woId = urlParams.get('id');
        console.log(urlParams.get('id'));

        var data = JSON.stringify(
            {
                "woId": woId,
                "processUid": 1
            }
        );
        $.ajax({
            url: "/work/wo/detail",
            dataType: "json",
            data: data,
            type: 'post',
            contentType: "application/json; charset=utf-8",
            success: function (res) {
                console.log(res.data);
                woDetail.orderDetail = res.data;
                
            }
        });
        var data = JSON.stringify(
            {
                "fieldValue": woId,
                "processUid": 1,
                "tableName":auditTableName
            }
        );
        $.ajax({
            url: "/work/auditTrace/list",
            dataType: "json",
            data: data,
            type: 'post',
            contentType: "application/json; charset=utf-8",
            success: function (res) {
                console.log(res.data);
                woDetail.auditDetails = res.data; 
            }
        });
    }

    initDetail();

});
