/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.HashSet;
import java.util.Set;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Method;

public class MethodAndImports {
    private Method method;
    private Set<FullyQualifiedJavaType> imports;
    private Set<String> staticImports;

    private MethodAndImports(Builder builder) {
        this.method = builder.method;
        this.imports = builder.imports;
        this.staticImports = builder.staticImports;
    }

    public Method getMethod() {
        return this.method;
    }

    public Set<FullyQualifiedJavaType> getImports() {
        return this.imports;
    }

    public Set<String> getStaticImports() {
        return this.staticImports;
    }

    public static Builder withMethod(Method method) {
        return new Builder().withMethod(method);
    }

    public static class Builder {
        private Method method;
        private Set<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        private Set<String> staticImports = new HashSet<String>();

        public Builder withMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder withImport(FullyQualifiedJavaType importedType) {
            this.imports.add(importedType);
            return this;
        }

        public Builder withImports(Set<FullyQualifiedJavaType> imports) {
            this.imports.addAll(imports);
            return this;
        }

        public Builder withStaticImport(String staticImport) {
            this.staticImports.add(staticImport);
            return this;
        }

        public Builder withStaticImports(Set<String> staticImports) {
            this.staticImports.addAll(staticImports);
            return this;
        }

        public MethodAndImports build() {
            return new MethodAndImports(this);
        }
    }
}

