package com.ydl.confide.api

import android.app.Activity
import android.app.Application
import android.content.Context
import android.content.Intent
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.FragmentActivity
import com.alibaba.android.arouter.facade.template.IProvider

interface IConfideService : IProvider {
    fun phoneCallIntent(activity: Activity): Intent

    fun phoneCallFragment(head: String, callId: String): DialogFragment

    fun closePlayer()

    //倾诉首页
    fun openConfideHome(context: Context)

    fun connectionJava(id: Int, type: Int, activity: Activity, tellData: String?, callType:String?)

    //直接拨打倾诉或者axb电话
    fun confideDial(id: Int, data: String, activity: Activity)

    fun ydlAvManagerLogin(uid: String?)

    fun startCondifeHomePage(context: Context, isSplash: Boolean)

    fun initYdlavManager(app: Application)

    fun showAxbConfirmDialog(activity: Activity?, type: Int, phoneNumber: String?)

    fun showExpertDetailDialog(
        activity: FragmentActivity,
        jumpUrl: String,
        doctorId: String,
        uid: String
    )

    fun requestConfidePermission(activity: FragmentActivity, call: ((Boolean) -> Unit)?)
}