package com.yidianling.im.api.service

import android.app.Activity
import android.app.Application
import android.content.Context
import androidx.fragment.app.Fragment
import com.alibaba.android.arouter.facade.template.IProvider
import com.yidianling.im.api.bean.*
import com.yidianling.im.api.listener.ApiStringResponseCallback

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/13
 */
interface IImService : IProvider {

    // 打开与小壹聊天界面
    fun startP2PXiaoYi(context: Context)

    // 打开私聊界面
    fun startP2PSession(context: Activity, toUid: String)

    // 直接打开聊天页面，不走分配导医
    fun startChatBySessionId(context: Activity, toUid: String)

    // 打开信息前置收集页
    fun startP2PSession(context: Activity, location: Int, ffrom2: String?)

    fun setAccount(account: String)

    fun setChattingAccountAll()

    fun setChattingAccountNone()

    fun isHasUnread(): Boolean

    fun login(info: IMLoginInfo, callback: IMRequestCallback<IMLoginInfo>?)

    /**
     * 绑定手机后，重新登录IM
     */
    fun imLogin(info: IMLoginInfo)

    fun logout()

    fun clear()

    /**
     * 创建一条普通文本消息
     * @param sessionId   聊天对象ID
     * @param content     文本消息内容
     */
    fun createTextMessage(sessionId: String?, content: String, callback: IMRequestCallback<Void>)

    fun sendSubscriptionTimeMessage(
        sessionId: String?,
        content: String,
        callback: IMRequestCallback<Void>
    )

    fun showSelector(activity: Activity, requestCode: Int)

    fun sendTestResultMessage(
        uid: String,
        content: String,
        title: String?,
        head: String?,
        url: String?,
        id: Int,
        share_url: String?,
        callback: IMRequestCallback<Void>
    )

    fun startChat(context: Activity, toUid: String, flag: Int, canTalk: Int)

    fun startChat(
        context: Activity,
        toUid: String,
        flag: Int,
        canTalk: Int,
        isFramQingsu: Int,
        isFromMessageList: Boolean
    )

    fun startChatCloseReplaceChat(context: Activity, toUid: String)


    /**
     * 根据对方uid获取未读数
     */
    fun getUnReadByUid(uid: String): Int


    /**
     * 获取自己的所有未读数
     */
    fun getAllUnReadNum(): Int

    /**
     * 发送自定义通知
     */
    fun sendCustomNotification(
        toUid: String,
        content: String,
        callback: IMSendCustomNotificationResultCallBack
    )

    /**
     * 注册自定通知接收器
     */
    fun registerObserveCustomNotification(callback: IMRegisterObserverCustomNotificationCallBack)

    fun unregisterObserveCustomNotification(callback: IMRegisterObserverCustomNotificationCallBack)


    fun getMultiMessageFragment(): Fragment

    // 跳转下一个未读数
    fun nextUnreadItem(fragment: Fragment): Boolean

    // 判断是否存在私聊页面
    fun isChatFragment(fragment: Fragment): Boolean

    // 判断云信是否登录
    fun isImLogin(): Boolean

    // 刷新未读数
    fun requestTopUnReadNumber(fragment: Fragment)

    // 登录IM
    fun loginIm(uid: String?, hxPwd: String?)

    //注销
    fun logoutAll()

    // 初始化imcache
    fun initImCache(mContext: Context)

    // 客服
    fun startKefuChat(context: Context, toUid: String, flag: Int, canTalk: Int)

    //
    fun startP2PSession(
        mContext: Context,
        userType: Int,
        account: String,
        toChatUsername: String,
        toName: String,
        head: String
    )

    fun updateUserHead(head: String?)

    fun updateUserName(name: String?)

    fun imInSetRing(bool: Boolean)

    fun imInSetVibrate(bool: Boolean)

    fun getUserInfoDescription(): String?

    fun getEarModeKey(): String

    fun getEarModeOpenType(): String

    fun getEarModeIsOpen(): Boolean

    fun getEarModeCloseType(): String

    fun updateEarMode(bool: Boolean)

    fun getChatUid(context: Context?, uid: String, callback: ApiStringResponseCallback)

    fun chatScheule(
        context: Activity,
        userUrl: String,
        docUrl: String,
        dsmId: Int,
        title: String,
        toUid: Int
    )

    fun initIm(app: Application, activity: Class<out Activity>, imInitBean: IMInitConfigBean)

    fun isWifiOr3G(activity: Activity): Boolean

    fun showConsultServiceDialog(activity: Activity, toUid: String, doctorId: String)

    fun dismissConsultServiceDialog();
    /**群聊*/
    fun startTeamSession(activity: Activity, tid: String, doctorId: String)
}