package com.ydl.component.api

import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.ydl.component.model.HomeFMBean
import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import io.reactivex.Observable
import retrofit2.http.GET
import retrofit2.http.Headers
import retrofit2.http.Query

/**
 * Created by haorui on 2019-09-01 .
 * Des:
 */
interface DemoService {

    @Headers(HEADER_API_VERSION, YDL_DOMAIN+DOMAIN_GITHUB)
    @GET("users")
    fun getUsers(@Query("since") lastIdQueried: Int, @Query("per_page") perPage: Int): Observable<JsonArray>

    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    @GET("home/index")
    fun getHomeData(): Observable<JsonObject>

    @GET("home/index")
    fun getHome1Data(): Observable<JsonObject>

    //首页电台请求
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    @GET("fm/list/all")
    fun getFMData(@Query("perPageRows") perPageRows: String = "4"): Observable<BaseAPIResponse<HomeFMBean>>


    companion object {
        const val HEADER_API_VERSION = "Accept: application/vnd.github.v3+json"
        const val DOMAIN_GITHUB = "github"
    }
}
