package com.ydl.component.base


import android.app.Application
import android.content.Context
import android.os.Build
import android.os.Looper
import android.os.Process
import android.util.Log
import androidx.annotation.RequiresApi
import com.channel.ydl_flutter_base.plugin.YDLCommonPlugin
import com.meituan.android.walle.WalleChannelReader
import com.tencent.bugly.crashreport.CrashReport
import com.tencent.smtt.sdk.QbSdk
import com.umeng.analytics.MobclickAgent
import com.umeng.commonsdk.UMConfigure
import com.umeng.socialize.PlatformConfig
import com.umeng.socialize.UMShareAPI
import com.ydl.component.BuildConfig
import com.ydl.component.MainActivity
import com.ydl.component.R
import com.ydl.ydlcommon.actions.crash.Cockroach
import com.ydl.ydlcommon.actions.crash.ExceptionHandler
import com.ydl.ydlcommon.base.config.YDLConstants
import com.ydl.ydlcommon.base.delegate.IAppLifecycles
import com.ydl.ydlcommon.utils.AppProgressUtils
import com.ydl.ydlcommon.utils.LogUtil
import com.ydl.ydlcommon.utils.log.LogHelper
import com.yidianling.common.tools.ToastUtil
import com.yidianling.im.api.bean.IMInitConfigBean
import com.yidianling.im.config.NimApplication
import io.flutter.view.FlutterMain

/**
 * Created by haorui on 2019-09-02.
 * Des:
 */
class DemoAppLifecycles : IAppLifecycles {

    override fun attachBaseContext(base: Context) {

    }

    @RequiresApi(api = Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    override fun onCreate(application: Application) {
        //模块初始化
        moduleInit(application)
        if (AppProgressUtils.isMainProcess(application)) {
            //第三方SDK初始化
            initThirdServiceSDK(application)
            //Flutter 初始化需要在主线程中执行
            FlutterMain.startInitialization(application)
            YDLCommonPlugin.pluginDelegate = object:YDLCommonPlugin.CommonPluginDelegate  {
                override fun getAppTheme(): HashMap<String, String> {
                    val map = HashMap<String, String>()
                    map["platform_main_theme"] = "#34CD65"
                    return map
                }

                override fun getSubChannelTheme(channelName: String): ArrayList<Any> {
                    val channelTheme = arrayListOf<Any>()
                    val items = mutableMapOf<String, String>()
                    items["index"] = "1"
                    items["type"] = "sort"
                    channelTheme.add(items)
                    return channelTheme
                }
            }
            //        FlutterMain.ensureInitializationComplete(application, null);
            //
            //        FlutterEngine flutterEngine = new FlutterEngine(application);
            //        flutterEngine.getDartExecutor().executeDartEntrypoint(DartExecutor.DartEntrypoint.createDefault());
            //        YDLCommonPlugin plugin = new YDLCommonPlugin();
            //        flutterEngine.getLocalizationChannel().channel.setMethodCallHandler(plugin);

        }
    }

    override fun onTerminate(application: Application) {}

    private fun moduleInit(application: Application) {
        val imInitConfigBean = IMInitConfigBean()
        imInitConfigBean.notificationIconRes = R.drawable.im_ic_launcher
        NimApplication.getInstance().initIm(application, MainActivity::class.java, imInitConfigBean)
    }


    private fun initThirdServiceSDK(application: Application) {
        object : Thread() {
            override fun run() {
                super.run()
                //设置线程优先级，不与主线程抢资源
                Process.setThreadPriority(Process.THREAD_PRIORITY_BACKGROUND)

                //子线程中初始化X5内核，防止ANR问题
                initX5(application)

                if (DemoGlobalConfig.appEnv == YDLConstants.ENV_PROD) {
                    //                    YDLavManager.Companion.getInstances().init(application, "3387e9b251f3491e9221a9877e8f7830");
                } else {
                    //                    YDLavManager.Companion.getInstances().init(application, "13b1536698f64905a1e7e5bb978ba821");
                }

                //异常拦截
                installCockroach(application)
                //bugly
                val packageName = application.packageName
                var channel = WalleChannelReader.getChannel(application)
                if (channel == null || channel == "null") {
                    channel = "test"
                }
                val strategy = CrashReport.UserStrategy(application)
                strategy.appChannel = channel
                val appkey = if (BuildConfig.DEBUG) "630a3a5cea" else "3939e71afa"
//                CrashReport.initCrashReport(application, appkey, BuildConfig.DEBUG, strategy)

                //umeng
                var umAppkey: String? = null
                if (BuildConfig.FLAVOR.endsWith("ydl")) {
                    umAppkey = "56970affe0f55a9cda001e24"
                    channel = "android_$channel"
                    initUM(umAppkey, channel, application)
                    PlatformConfig.setWeixin(
                        "wx57a9d930270498c7",
                        "17c031f02500ded3457a80e69d8e5e45"
                    )
                    PlatformConfig.setQQZone("1105070461", "6BvkUnk6wXJekcgR")
                } else if (BuildConfig.FLAVOR.endsWith("xlzx")) {
                    umAppkey = "5859e1656e27a42fa400021f"
                    channel = "ATK_7_android_$channel"
                    initUM(umAppkey, channel, application)
                    PlatformConfig.setWeixin(
                        "wx1c6af5a11b5f531f",
                        "1ddb93abbb2d81e604657d38e94a5720"
                    )
                    PlatformConfig.setQQZone("1107931541", "8dCvxUpi525uPGTJ")
                }

                // 选用AUTO页面采集模式
                MobclickAgent.setPageCollectionMode(MobclickAgent.PageMode.AUTO)
                MobclickAgent.setCatchUncaughtExceptions(!BuildConfig.DEBUG)

                //开启友盟集成测试
                UMConfigure.setLogEnabled(BuildConfig.DEBUG)

                //安全检测
                //YDLAppProtector.init();

            }
        }.start()
    }


    private fun initUM(umAppKey: String?, channel: String?, application: Application) {
        /**
         * 初始化common库
         * 参数1:上下文，不能为空
         * 参数2:友盟 app key
         * 参数3:友盟 channel
         * 参数4:设备类型，UMConfigure.DEVICE_TYPE_PHONE为手机、UMConfigure.DEVICE_TYPE_BOX为盒子，默认为手机
         * 参数5:Push推送业务的secret
         */
        UMConfigure.init(application, umAppKey, channel, UMConfigure.DEVICE_TYPE_PHONE, null)
        UMShareAPI.init(application, umAppKey)
    }


    /**
     * 初始化X5内核
     *
     * @param application
     */
    private fun initX5(application: Application) {
        // 在调用TBS初始化、创建WebView之前进行如下配置，以开启优化方案
        //        HashMap map = new HashMap();
        //        map.put(TbsCoreSettings.TBS_SETTINGS_USE_SPEEDY_CLASSLOADER, true);
        //        QbSdk.initTbsSettings(map);

        //        if (!QbSdk.isTbsCoreInited()) {//// preinit只需要调用一次，如果已经完成了初始化，那么就直接构造view
        //            QbSdk.preInit(application, null);// 设置X5初始化完成的回调接口
        //        }

        val cb = object : QbSdk.PreInitCallback {

            override fun onViewInitFinished(arg0: Boolean) {
                //初始化完成回调
                LogUtil.i("QbSdk onViewInitFinished：$arg0")
            }

            override fun onCoreInitFinished() {
                LogUtil.i("QbSdk onCoreInitFinished")
            }
        }
        QbSdk.initX5Environment(application, cb)

    }

    /**
     * 初始化异常拦截器
     */
    private fun installCockroach(application: Application) {
        val sysExcepHandler = Thread.getDefaultUncaughtExceptionHandler()
        Cockroach.install(application, object : ExceptionHandler() {
            override fun onUncaughtExceptionHappened(thread: Thread, throwable: Throwable) {
                if (BuildConfig.DEBUG) {
                    ToastUtil.toastShort(throwable.message)
                }

                LogHelper.getInstance().writeLogSync(throwable.localizedMessage)
                LogHelper.getInstance().uploadLog(false)
            }

            override fun onBandageExceptionHappened(throwable: Throwable) {
                throwable.printStackTrace()//打印警告级别log，该throwable可能是最开始的bug导致的，无需关心
                LogHelper.getInstance().writeLogSync(throwable.localizedMessage)
            }

            override fun onEnterSafeMode() {}

            override fun onMayBeBlackScreen(e: Throwable?) {
                val thread = Looper.getMainLooper().thread
                Log.e("AndroidRuntime", "--->onUncaughtExceptionHappened:$thread<---", e)
                //黑屏时建议直接杀死app
                sysExcepHandler.uncaughtException(thread, RuntimeException("black screen"))

                LogHelper.getInstance().writeLogSync(e!!.localizedMessage)
            }
        })
    }

}