package com.ydl.component.mvp

import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.ydl.component.model.HomeFMBean
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.lce.ILceView
import io.reactivex.Observable

/**
 * Created by haorui on 2019-08-12.
 * Des:
 */
interface DemoContract {
    interface View : ILceView {
        fun setData(data: String)
    }

    interface Presenter : IPresenter<View> {
        fun loadUsers()
        fun loadHome()
        fun loadFmMusic()
    }

    interface Model : IModel{
        fun getUser(): Observable<JsonArray>
        fun getHome(): Observable<JsonObject>
        fun getFmMusic(): Observable<HomeFMBean>
    }

}