package com.ydl.component.rtc.http

import com.google.gson.Gson
import com.ydl.component.rtc.bean.UserSigBean
import com.ydl.component.rtc.bean.UserSigResponse
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlnet.YDLHttpUtils
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

class MDTHttpImpl :MDTHttp {
    private var mdtService: MDTService? = null

    object Holder {
        val INSTANCE = MDTHttpImpl()
    }

    companion object {
        fun getInstance(): MDTHttpImpl {
            return Holder.INSTANCE
        }
    }


    private fun getMdtService(): MDTService {
        if (mdtService == null) {
            mdtService = YDLHttpUtils.obtainApi(MDTService::class.java)
        }
        return mdtService!!
    }

    //获取登录信息
    override fun getSecret(bean: UserSigResponse): Observable<BaseAPIResponse<UserSigBean>> {
        val str = Gson().toJson(bean)
        val body: RequestBody =
            RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str)
        return getMdtService().getSecret(body)
    }


}