package activity

import adapter.ArticlePagerAdapter
import android.annotation.SuppressLint
import android.graphics.Typeface
import android.text.SpannableString
import android.text.Spanned
import android.text.style.StyleSpan
import android.widget.ImageView
import androidx.viewpager2.widget.ViewPager2
import com.alibaba.android.arouter.facade.annotation.Route
import com.google.android.material.tabs.TabLayout
import com.google.android.material.tabs.TabLayoutMediator
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.article.R
import fragment.ArticleHomeFragment
import http.ArticleHttp
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers


@Route(path = "/article/list")
class ArticleHomeActivity : BaseActivity() {

    private var TAG_IDS = mutableListOf(0)
    private var mTabName = mutableListOf("推荐")
    private var mTabLayout: TabLayout? = null
    private var mViewPager: ViewPager2? = null

    private var mFragments = mutableListOf(ArticleHomeFragment.newInstance(0))

    override fun layoutResId(): Int {
        return R.layout.article_home_activity_layout
    }
    override fun initDataAndEvent() {
        mTabLayout = findViewById(R.id.tab_layout)
        mViewPager = findViewById(R.id.view_pager)

        mViewPager?.offscreenPageLimit = 3

        findViewById<ImageView>(R.id.iv_back).setOnClickListener {
            ActionCountUtils.record("article_list_main_page","article_list_return_click")
            finish()
        }

        loadData()
    }

    @SuppressLint("CheckResult")
    private fun loadData() {
        ArticleHttp.getInstance().getArticleCategoryList()
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe { response ->
                if (response.code == "200" && response.data != null && !response.data.articleCategoryResponseList.isNullOrEmpty()) {
                    var tabNameString = StringBuffer("推荐")
                    response.data.articleCategoryResponseList!!.forEach {
                        mTabName.add(it.name)
                        TAG_IDS.add(it.categoryId)
                        mFragments.add(ArticleHomeFragment.newInstance(it.categoryId))
                        tabNameString.append("|${it.name}")
                    }
                    ActionCountUtils.record(
                        "article_list_main_page",
                        "article_list_sort_visit",
                        tabNameString.toString()
                    )
                    mViewPager?.post {
                        mViewPager?.adapter = ArticlePagerAdapter(this, mFragments)

                        mTabLayout?.addOnTabSelectedListener(object :
                            TabLayout.OnTabSelectedListener {
                            override fun onTabSelected(tab: TabLayout.Tab?) {
                                ActionCountUtils.record(
                                    "article_list_main_page",
                                    "article_list_toptitle_click",
                                    tab?.text.toString() ?: ""
                                )
                                var text: String? = tab?.text.toString().trim()
                                val spStr = SpannableString(text)
                                val styleSpan = StyleSpan(Typeface.BOLD)
                                spStr.setSpan(
                                    styleSpan,
                                    0,
                                    text?.length ?: 0,
                                    Spanned.SPAN_INCLUSIVE_EXCLUSIVE
                                )
                                tab?.text = spStr
                            }

                            override fun onTabUnselected(tab: TabLayout.Tab?) {
                                var text: String? = tab?.text.toString().trim()
                                val spStr = SpannableString(text)
                                val styleSpan = StyleSpan(Typeface.NORMAL)
                                spStr.setSpan(
                                    styleSpan,
                                    0,
                                    text?.length ?: 0,
                                    Spanned.SPAN_INCLUSIVE_EXCLUSIVE
                                )
                                tab?.text = spStr
                            }

                            override fun onTabReselected(tab: TabLayout.Tab?) {

                            }

                        })

                        TabLayoutMediator(mTabLayout!!, mViewPager!!) { tab, position ->
                            tab.text = mTabName[position]
                        }.attach()
                    }
                }
            }
    }


}