package com.yidianling.article.flutter

import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydlcommon.utils.AppUtils
import com.ydl.ydlcommon.view.dialog.YDLShareDialog
import com.yidianling.common.tools.ToastUtil
import io.flutter.app.FlutterActivity
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel

/**
 * Created by harvie on 2019/9/6.
 */
class ArticlePlugin : MethodChannel.MethodCallHandler {

    companion object {
        const val CHANNEL: String = "lib/m_module/article"

        const val ACTION_TO_H5 = "action_to_h5" //跳转原生H5
        const val ACTION_GET_COMMON_PARAMS = "action_get_common_params" //获取http公用参数

        fun rigister(activity: FlutterActivity) {
            MethodChannel(activity.flutterView, CHANNEL).setMethodCallHandler(ArticlePlugin(activity))
        }
    }


    private var mActivity: FlutterActivity? = null

    private constructor(activity: FlutterActivity) {
        mActivity = activity
    }

    override fun onMethodCall(methodCall: MethodCall, result: MethodChannel.Result) {
        methodCall.let {
            when (methodCall.method) {
                // flutter获取原生的功能
                ACTION_TO_H5 -> {
                    var url: String? = methodCall.argument<String>("url")
                    YDLRouterManager.router("ydl-user://h5/h5?params={'url':'${url}'}")
//                    NewH5Activity.start(mActivity, H5Params(url?:"",null))
                }
                ACTION_GET_COMMON_PARAMS -> {
                    val map = AppUtils.getHttpCommonParams()
                    result?.success(map)
                }

                else -> {

                }
            }
        }
    }

    /**
     * 分享，跟FM一致
     */
    private fun share(methodCall: MethodCall?) {
        var shareUrl = methodCall?.argument<String>("shareUrl") ?: ""
        var title = methodCall?.argument<String>("title") ?: ""
        var path = methodCall?.argument<String>("path") ?: ""
        var appId = methodCall?.argument<String>("appId") ?: ""
        if (shareUrl.isEmpty()) {
            ToastUtil.toastShort("分享数据获取失败")
        } else {
            val dialog = YDLShareDialog.style7(mActivity!!, title, shareUrl, null, "https://img.yidianling.com/file/2019/06/10/fm0vovijx0p2br9s.png", path, appId)
            dialog.setCallBack(object : YDLShareDialog.ICallBack {
                override fun callBack(type: Int) {
                }
            })
            dialog.show(mActivity!!.fragmentManager, "lose")
        }
    }

}