package com.ydl.audioim

import android.app.*
import android.content.Context
import android.content.Intent
import android.os.Build

class AudioService : Service() {


    override fun onCreate() {
        val createNotification = createNotification(this)
        startForeground(12001, createNotification)
    }


    override fun onBind(intent: Intent?) = null


    private fun createNotification(context: Context): Notification = when {
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.O -> {
            // 创建消息渠道
            val channel =
                NotificationChannel("EasyFloat", "系统悬浮窗", NotificationManager.IMPORTANCE_MIN)
            val manager =
                context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            manager.createNotificationChannel(channel)

            Notification.Builder(context, "EasyFloat")
                .setCategory(Notification.CATEGORY_SERVICE)
        }

        Build.VERSION.SDK_INT >= Build.VERSION_CODES.N ->
            Notification.Builder(context)
                .setCategory(Notification.CATEGORY_SERVICE)
                .setPriority(Notification.PRIORITY_MIN)

        else -> Notification.Builder(context)
    }
//        .setSmallIcon(R.drawable.audioim_audio_home_img_answer)
//        .setContentText("正在通话中")
//        .setContentIntent(PendingIntent.getActivity(context, 0, Intent(context, MainActivity::class.java), 0))
        .setAutoCancel(true)
        .setOngoing(true)
        .build()

}