package com.ydl.audioim.http

import com.google.gson.Gson
import com.ydl.audioim.bean.AgoraTokenResponse
import com.ydl.audioim.bean.CallEventRequestBody
import com.ydl.audioim.bean.ConnectBean
import com.ydl.audioim.http.command.ConnectCommand
import com.ydl.audioim.http.command.ConnectExceptionCommand
import com.ydl.audioim.http.command.NoticePushCommand
import com.ydl.consultantim.bean.ListenTokenBean
import com.ydl.consultantim.command.ListenTokenCmd
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.utils.NetworkParamsUtils
import com.ydl.ydlcommon.utils.TimeUtil
import com.ydl.ydlnet.YDLHttpUtils
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * @author jiucheng
 * @描述:声网业务接口请求
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/9
 */
class AudioApiRequestUtil {
    companion object {
        /**
         * 倾诉
         */
        fun connectListen(cmd: ConnectCommand): Observable<BaseAPIResponse<ConnectBean>> {
            return RxUtils.mapObservable(cmd)
                .flatMap { it ->
                    YDLHttpUtils.obtainApi(AudioNetAPi::class.java).connectListen(it)
                }
        }

        /**
         * 通话开始回调
         *
         * @param param
         * @return
         */
//        fun connectStart(param: ConnectStartCommand): Observable<BaseAPIResponse<Any>> {
////            val list = YdlRetrofitUtils.getPostList(param)
//            var str = Gson().toJson(param)
//            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str) as RequestBody
//            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java).connectStart(body)
//        }

        /**
         * 通话结束回调
         *
         * @param param
         * @return
         */
//        fun connectFinish(param: ConnectFinishCommand): Observable<BaseAPIResponse<Any>> {
////            val list = YdlRetrofitUtils.getPostList(param)
//            var str = Gson().toJson(param)
//            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str) as RequestBody
//            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java).connectFinish(body)
//        }

        /**
         * 通话警告与异常回调
         *
         * @param param
         * @return
         */
        fun connectException(param: ConnectExceptionCommand): Observable<BaseAPIResponse<Any>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                str
            ) as RequestBody
            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java).connectException(body)
        }

        /**
         * 通知服务端发送推送
         */
        fun noticeServerPush(param: NoticePushCommand): Observable<BaseResponse<Any>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                str
            ) as RequestBody
            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java).noticeServerPush(body)
        }

        /**
         * 获取声网登录token
         */
        fun getAgoraToken(): Observable<BaseAPIResponse<AgoraTokenResponse>> {
            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java).getAgoraToken()
        }

        /**
         * 获取声网登录token
         */
        fun listenToken(cmd: ListenTokenCmd): Observable<BaseResponse<ListenTokenBean>> {
            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java)
                .listenToken(NetworkParamsUtils.getMaps(cmd))
        }

        fun callEndStatusUpdate(
            channelId: String,
            endStatus: Int,
            msg: String
        ): Observable<BaseAPIResponse<Any>> {
            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java)
                .callEndStatusUpdate(channelId, endStatus, msg)
        }

        fun callEventSave(
            session: String?,
            line: String,
            status: String,
            response: String
        ): Observable<BaseAPIResponse<Any>> {
            var eventTime = TimeUtil.getNowDatetime()
            var param = CallEventRequestBody(session, line, status, response, eventTime);
            var str = Gson().toJson(param)
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                str
            ) as RequestBody
            return YDLHttpUtils.obtainApi(AudioNetAPi::class.java).callEventSave(body)
        }
    }
}