package com.ydl.audioim.modular

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.net.Uri
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.audioim.YDLavManager
import com.ydl.audioim.api.IAudioImService
import com.ydl.audioim.widget.AxbConfirmDialog

/**
 * Created by Ykai on 2022/7/26.
 */

@Route(path = "/audioim/AudioImService")
class AudioImServiceImp : IAudioImService {

    override fun yDLAvManagerInit(context: Context, appId: String) {
        YDLavManager.instances.init(context, appId)
    }


    override fun getIsOnlineRtm(): Boolean {
        return YDLavManager.isOnlineRtm
    }

    override fun loginRtm(userId: String?, event: (isSuccess: Boolean, msg: String?) -> Unit) {
        YDLavManager.instances.login(userId, event)
    }

    override fun loginRtm(userId: String?) {
        YDLavManager.instances.login(userId)
    }

    override fun openAxbDialog(activity: Activity?, type: Int, phoneNumber: String?) {
        val dialog = AxbConfirmDialog(activity, type, object : AxbConfirmDialog.OnClickEnsureListener {
                override fun onClickEnsure() {
                    phoneNumber?.let {
                        val phoneIntent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:$phoneNumber"))
                        activity?.startActivity(phoneIntent)
                    }
                }

                override fun onClose() {

                }
            })
        dialog.show()
    }

    override fun callEventSave(status: String, res: String, session: String?, line: String) {
        YDLavManager.instances.callEventSave(status, res, session, line)
    }

    override fun init(context: Context?) {

    }
}