package com.ydl.audioim.router

import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.im.api.bean.IMRegisterObserverCustomNotificationCallBack
import com.yidianling.im.api.bean.IMSendCustomNotificationResultCallBack
import com.yidianling.im.api.service.IImService
import com.yidianling.user.api.service.IUserService


/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2020/4/21
 */
object AudioImIn {
    private fun getImService(): IImService {
        return ModularServiceManager.provide(IImService::class.java)
    }
    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }
    /**
     * 发送自定义通知
     */
    fun sendCustomNotification(toUid: String, content: String, callback: IMSendCustomNotificationResultCallBack) {
        getImService().sendCustomNotification(toUid, content, callback)
    }

    /**
     * 注册自定通知接收器
     */
    fun registerObserveCustomNotification(callback: IMRegisterObserverCustomNotificationCallBack) {
        getImService().registerObserveCustomNotification(callback)
    }
}