package com.ydl.audioim.utils

import com.apm.insight.log.VLog
import com.bytedance.apm.insight.ApmInsightAgent
import com.ydl.ydlcommon.modular.ModularServiceManager
import org.json.JSONObject

internal fun onConfideEvent(dimension: HashMap<String, String>, channel: String?) {
    try {
        val uid = ModularServiceManager.getPlatformUserService()?.getUser()?.userId
        val ext = JSONObject(mapOf("uid" to uid, "channelId" to (channel ?: "unknown")))
        ApmInsightAgent.monitorEvent("confide", dimension, hashMapOf(), ext)
    } catch (throwable: Throwable) {
        VLog.e("onConfideEvent", throwable.message)
    }
}