package com.ydl.audioim.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;

import java.lang.ref.WeakReference;

/**
 * Created on 2018/1/18  11:32
 *
 * @author Z
 * @version : 1.0.0
 */

public class ZDialogController {
    private ZDialog mZDialog;
    private Window mWindow;
    private ZDialogViewHelper mZDialogViewHelper;

    public ZDialogController(ZDialog ZDialog, Window window) {
        mZDialog = ZDialog;
        mWindow = window;
    }

    public ZDialog getZDialog() {
        return mZDialog;
    }

    public Window getWindow() {
        return mWindow;
    }

    public void setZDialogViewHelper(ZDialogViewHelper ZDialogViewHelper) {
        mZDialogViewHelper = ZDialogViewHelper;
    }

    public void setText(int viewId, CharSequence charSequence) {
        mZDialogViewHelper.setText(viewId, charSequence);
    }

    public EditText getEditText(int viewId) {
        return mZDialogViewHelper.getEditText(viewId);
    }

    public View findView(int viewId) {
        return mZDialogViewHelper.findView(viewId);
    }

    public void setOnClickListener(int viewId, View.OnClickListener onClickListener) {
        mZDialogViewHelper.setOnClickListener(viewId, onClickListener);
    }

    /**
     * ZDialog 显示出来可能需要的一些参数
     */
    public static class ZDialogParams {
        public WeakReference<Context> context;
        public int themeResId;// dialog 的style
        public boolean cancelable;
        public View contentView;
        public int contentResId;
        public int defaultWidth = ViewGroup.LayoutParams.WRAP_CONTENT;
        public int defaultHeight = ViewGroup.LayoutParams.WRAP_CONTENT;
        public int direction = Gravity.CENTER;
        public int animation = 0;
        public SparseArray<CharSequence> textArray = new SparseArray<>();
        public SparseArray<View.OnClickListener> clickViewArray = new SparseArray<>();

        public DialogInterface.OnCancelListener onCancelListener;
        public DialogInterface.OnDismissListener onDismissListener;
        public DialogInterface.OnKeyListener onKeyListener;


        public ZDialogParams(Context context, int themeResId) {
            this.context = new WeakReference<>(context);
            this.themeResId = themeResId;
        }

        public void apply(ZDialogController controller) {
            //创建ZDialogViewHelper
            ZDialogViewHelper viewHelper = null;
            if (contentResId != 0) {
                viewHelper = new ZDialogViewHelper(context.get(), contentResId);
            }
            if (contentView != null) {
                viewHelper = new ZDialogViewHelper();
                viewHelper.setContentView(contentView);
            }
            if (viewHelper == null) {
                throw new IllegalArgumentException("please do setContentView() first");
            }

            //添加布局到dialog
            if (viewHelper.getContentView() != null) {
                controller.getZDialog().setContentView(viewHelper.getContentView());
            }

            controller.setZDialogViewHelper(viewHelper);

            for (int i = 0; i < textArray.size(); i++) {
                controller.setText(textArray.keyAt(i), textArray.valueAt(i));
            }

            for (int i = 0; i < clickViewArray.size(); i++) {
                controller.setOnClickListener(clickViewArray.keyAt(i), clickViewArray.valueAt(i));
            }


            Window window = controller.getWindow();
            window.setGravity(direction);
            if (animation != 0) {
                window.setWindowAnimations(animation);
            }
            WindowManager.LayoutParams attributes = window.getAttributes();
            attributes.width = defaultWidth;
            attributes.height = defaultHeight;
            window.setAttributes(attributes);


        }


    }
}
