package com.ydl.consultantim.presenter

import android.annotation.SuppressLint
import com.ydl.audioim.http.AudioApiRequestUtil
import com.ydl.consultantim.command.ListenTokenCmd
import com.ydl.consultantim.contract.IConsultantAudioHomeActivityContract
import com.ydl.consultantim.model.ConsultantAudioHomeModelImpl
import com.ydl.ydl_av.chat.bean.AudioMessageBean
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.mvp.base.BasePresenter
import com.yidianling.user.api.service.IUserService
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * @author jiucheng
 * @描述:声网通话页面逻辑实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/10/30
 */
class ConsultantAudioHomePresenterImpl :
    BasePresenter<IConsultantAudioHomeActivityContract.View, IConsultantAudioHomeActivityContract.Model>(),
    IConsultantAudioHomeActivityContract.Presenter {

    override fun userIsInChannel(channelName: String, agoraUid: String) {
//        RetrofitUtils.userIsInChannel(channelName, agoraUid)
//            .subscribeOn(Schedulers.io())
//            .observeOn(AndroidSchedulers.mainThread())
//            .subscribe({
//                view.executeCall(it.data)
//            }, {
//                LogUtil.e("agora", "专家进入前判断用户是否在频道内接口异常:" + it.message)
//            })
    }

    @SuppressLint("CheckResult")
    override fun getChannelToken(msgBean: AudioMessageBean?, needJoinChannel: Boolean) {
        if (ModularServiceManager.provide(IUserService::class.java).isLogin()) {
            if (null != ModularServiceManager.provide(IUserService::class.java).getUserInfo()) {
                val acount =
                    ModularServiceManager.provide(IUserService::class.java).getUserInfo()?.uid
                val tokenParam = ListenTokenCmd()
                tokenParam.type = "TOKEN"
                tokenParam.account = acount.toString()
                tokenParam.uid = acount.toString()
                tokenParam.channelId = msgBean?.channelId
                AudioApiRequestUtil.listenToken(tokenParam)
                    .subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe({
                        mView.channelTokenResponse(it.data.token, needJoinChannel)
                    }, {
                    })
            }
        }
    }

    override fun createModel(): IConsultantAudioHomeActivityContract.Model {
        return ConsultantAudioHomeModelImpl()
    }
}
