package com.ydl.confide.home.adapter

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ObservableField
import androidx.databinding.ObservableInt
import androidx.recyclerview.widget.RecyclerView
import com.ydl.confide.R
import com.ydl.confide.databinding.ItemConfideHomeRecentBinding
import com.ydl.confide.databinding.ItemVideoShowBinding
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.intro.BindingViewHolder
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils

class VideoShowAdapter(private val data: List<ConfideHomeBodyBean>?, private val event: IConfideHomeEvent) :
    RecyclerView.Adapter<BindingViewHolder<ItemVideoShowBinding>>() {
    private val dataList: List<ItemVideoShowViewModel> = data?.map { ItemVideoShowViewModel().mapOf(it) } ?: emptyList()
    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): BindingViewHolder<ItemVideoShowBinding> {
        val layoutInflater = LayoutInflater.from(parent.context)
        val binding =
            DataBindingUtil.inflate<ItemVideoShowBinding>(layoutInflater, R.layout.item_video_show, parent, false)
        return BindingViewHolder(binding)
    }

    override fun onBindViewHolder(holder: BindingViewHolder<ItemVideoShowBinding>, position: Int) {
        val itemVideoShowViewModel = dataList[position]
        holder.binding.item = itemVideoShowViewModel
        holder.itemView.setOnClickListener {
            ActionCountUtils.record("listen_counselor_list_page", "video_card_click")
            event.videoShowClick(position, data)
        }
    }

    override fun getItemCount() = dataList.size
}


class RecentConfideAdapter(val data: List<ItemVideoShowViewModel>, private val event: IConfideHomeEvent) :
    RecyclerView.Adapter<BindingViewHolder<ItemConfideHomeRecentBinding>>() {
    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): BindingViewHolder<ItemConfideHomeRecentBinding> {
        val layoutInflater = LayoutInflater.from(parent.context)
        val binding =
            DataBindingUtil.inflate<ItemConfideHomeRecentBinding>(
                layoutInflater,
                R.layout.item_confide_home_recent,
                parent,
                false
            )
        return BindingViewHolder(binding)
    }

    override fun onBindViewHolder(holder: BindingViewHolder<ItemConfideHomeRecentBinding>, position: Int) {
        val itemVideoShowViewModel = data[position]
        holder.binding.item = itemVideoShowViewModel
        holder.itemView.setOnClickListener {
            ActionCountUtils.record("listen_counselor_list_page", "head_portrait_click", "1")
            ActionCountUtils.record(
                "listen_counselor_popupwindows_page",
                "popupwindows_page_visit",
                itemVideoShowViewModel.confideId ?: "", "2"
            )
            event.consultantClick(
                itemVideoShowViewModel.doctorId,
                itemVideoShowViewModel.confideId,
                itemVideoShowViewModel.uid
            )
        }
    }

    override fun getItemCount() = data.size
}

class ItemVideoShowViewModel {
    val name = ObservableField<String>("")
    val coverUrl = ObservableField<String>("")
    val videoCoverUrl = ObservableField<String>("")
    val state = ObservableInt()
    var doctorId: String? = null
    var confideId: String? = null
    var uid: String? = null
}

internal fun ItemVideoShowViewModel.mapOf(bean: ConfideHomeBodyBean): ItemVideoShowViewModel {
    name.set(bean.videoTitle ?: "")
    coverUrl.set(bean.confidedIcon)
    if (bean.coverVideoPicture.isNullOrBlank()) {
        videoCoverUrl.set(bean.coverPicture)
    } else {
        videoCoverUrl.set(bean.coverVideoPicture)
    }
    state.set(bean.confideLine ?: 0)
    doctorId = bean.doctorId
    confideId = bean.confidedId
    uid = bean.uid?.toString()
    return this
}





