package com.ydl.confide.home.http

import com.ydl.confide.home.bean.ConfideConnectResponse
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.bean.DialStatus
import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import io.reactivex.Observable
import retrofit2.http.*

/**
 * @author yuanwai
 * @描述:倾诉首页Api
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
interface ConfideHomeApi {
    //倾诉首页
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET
    fun confideHome(
        @Url url: String,
        @Query("cateSource") cateSource: Int
    ): Observable<BaseAPIResponse<MutableList<ConfideHomeDataBean>>>

    //每日精选 换一批
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET
    fun recommedChange(@Url url: String): Observable<BaseAPIResponse<ConfideHomeDataBean>>

    //连接-java接口
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("auth/listen/dial")
    fun connectJava(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<ConfideConnectResponse>>

    //拨打前  下单支付接口
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("auth/listen/submitOrderAndPay")
    fun submitOrderAndPay(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<ConfideConnectResponse>>

    // 1=在线 3-通话中 2-离线
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    @GET("auth/listen/dialchangestatus")
    fun getDialStatus(@Query("doctorId") doctorId: String, @Query("listenVersion")listenVersion : String = "2.1"): Observable<BaseAPIResponse<DialStatus>>

    @GET
    fun recommendDoctor(
        @Url url: String,
        @Query("page") page: Int,
        @Query("businessSource") source: Int
    ): Observable<BaseAPIResponse<ConfideHomeDataBean>>
}