package com.ydl.confide.home.http

import com.ydl.confide.home.bean.ConfideConnectResponse
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.bean.ConnectParamJava
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlnet.YDLHttpUtils
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:倾诉首页接口实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
class ConfideHomeHttpImpl private constructor() : IConfideHomeHttp {

    companion object {
        fun getInstance(): ConfideHomeHttpImpl {
            return Holder.INSTANCE
        }
    }

    object Holder {
        val INSTANCE = ConfideHomeHttpImpl()
    }

    private val confideHomeApi: ConfideHomeApi by lazy {
        YDLHttpUtils.obtainApi(ConfideHomeApi::class.java)
    }

    override fun confideHomeRequest(): Observable<BaseAPIResponse<MutableList<ConfideHomeDataBean>>> {
        return RxUtils.mapObservable(ConfideHomeParam(0))
            .flatMap {
                confideHomeApi.confideHome(HttpConfig.JAVA_BASE_URL + "auth/listen/nhome?listenVersion=2.0", 2)
            }
    }

    override fun recommendList(param: ConfideRecommendParam): Observable<BaseAPIResponse<ConfideHomeDataBean>> {

        val inUid = StringBuffer()
        for (i in param.notInUid.indices) {
            inUid.append(param.notInUid[i])
            if (i < param.notInUid.size - 1) {
                inUid.append(",")
            }
        }

        val sb = StringBuffer()
        sb.append("page").append("=").append(param.page).append("&")
            .append("keywords").append("=").append(param.getKeywords()).append("&")
            .append("sortType").append("=").append(param.getSortType()).append("&")
            .append("sexType").append("=").append(param.getSexType()).append("&")
            .append("ageType").append("=").append(param.getAgeType()).append("&")
            .append("goodType").append("=").append(param.getGoodType()).append("&")
            .append("notInUid").append("=").append(inUid.toString()).append("&")
        val confideParam = sb.toString()
        return RxUtils.mapObservable(param)
            .flatMap {
                confideHomeApi.recommedChange(HttpConfig.JAVA_BASE_URL + "auth/listen/nsearch?" + confideParam)
            }
    }

    override fun connectionJava(connectParam: ConnectParamJava): Observable<BaseAPIResponse<ConfideConnectResponse>> {
        return RxUtils.mapObservable(connectParam)
            .flatMap { it ->
                YDLHttpUtils.obtainApi(ConfideHomeApi::class.java).connectJava(it)
            }
    }

    override fun submitOrderAndPay(connectParam: ConnectParamJava): Observable<BaseAPIResponse<ConfideConnectResponse>> {
        return RxUtils.mapObservable(connectParam)
            .flatMap { it ->
                YDLHttpUtils.obtainApi(ConfideHomeApi::class.java).submitOrderAndPay(it)
            }
    }
}