package com.ydl.confide.home.modular.service

import android.app.Activity
import android.app.Application
import android.content.Context
import android.content.Intent
import android.text.TextUtils
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.FragmentActivity
import com.alibaba.android.arouter.facade.annotation.Route
import com.google.gson.Gson
import com.ydl.audioim.api.IAudioImService
import com.ydl.confide.api.IConfideService
import com.ydl.confide.home.ConfideBottomSheetDialogFragment
import com.ydl.confide.home.ConfideHomeActivity
import com.ydl.confide.home.ConfidePermissionDialog
import com.ydl.confide.home.bean.ConfideConnectResponse
import com.ydl.webview.TellData
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.base.config.YDLConstants
import com.ydl.ydlcommon.modular.findRouteService
import com.ydl.ydlcommon.utils.YDLCacheUtils

/**
 * Created by haorui on 2019-12-11 .
 * Des:
 */
@Route(path = "/confide/ConfideService")
class ConfdieServiceImpl : IConfideService {

    override fun init(context: Context?) {

    }


    override fun phoneCallFragment(head: String, callId: String): DialogFragment {
        //废弃
        return DialogFragment()
    }

    override fun phoneCallIntent(activity: Activity): Intent {
        //废弃
        val intent = Intent(activity, ConfideHomeActivity::class.java)
        return intent
    }

    override fun openConfideHome(context: Context) {
        val intent = Intent(context, ConfideHomeActivity::class.java)
        if (context !is Activity) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        }
        context.startActivity(intent)
    }

    override fun connectionJava(id: Int, type: Int, activity: Activity, tellData: String?, callType: String?) {
        val myTellData: TellData? = if (tellData == null ) null else Gson().fromJson(tellData, TellData::class.java)
        ConfideWebServiceImpl().connectionJava(id, type, activity, myTellData, callType)
    }

    /**
     * 直接拨打
     * */
    override fun confideDial(id: Int, data: String, activity: Activity) {
        val gson = Gson()
        val bean = gson.fromJson(data, ConfideConnectResponse::class.java)
        if (bean?.dialDetail?.callConnectType == 3) {
            ConfideWebServiceImpl().agora(id, activity, bean)
        } else {
            ConfideWebServiceImpl().axb(activity, bean?.dialDetail?.phoneNu)
        }
    }


    override fun ydlAvManagerLogin(uid: String?) {
        findRouteService(IAudioImService::class.java).loginRtm(uid)
    }

    override fun startCondifeHomePage(context: Context, isSplash: Boolean) {
        val intent1 = Intent(context, ConfideHomeActivity::class.java)
        intent1.putExtra("isSplash", isSplash)
        intent1.flags = Intent.FLAG_ACTIVITY_NEW_TASK
        context.startActivity(intent1)
    }

    override fun initYdlavManager(app: Application) {

        var avManagerKey = ""
        if (BaseApp.instance.getGlobalConfig().appDebug) {
            val appEnv = BaseApp.instance.getGlobalConfig().appEnv

            //debug包根据url判断使用正式或者测试key
            val cacheAppEnv = YDLCacheUtils.getCacheApi()
            avManagerKey = if (!TextUtils.isEmpty(cacheAppEnv)) {
                if (YDLConstants.ENV_TEST == cacheAppEnv) {
                    "13b1536698f64905a1e7e5bb978ba821"
                } else {
                    "3387e9b251f3491e9221a9877e8f7830"
                }
            } else {
                if (YDLConstants.ENV_TEST == appEnv || YDLConstants.ENV_AUTO_TEST == appEnv) {
                    "13b1536698f64905a1e7e5bb978ba821"
                } else {
                    "3387e9b251f3491e9221a9877e8f7830"
                }
            }
        } else {
            //release包始终使用正式key
            avManagerKey = "3387e9b251f3491e9221a9877e8f7830"
        }

        findRouteService(IAudioImService::class.java).yDLAvManagerInit(app, avManagerKey)
    }

    override fun showAxbConfirmDialog(activity: Activity?, type: Int, phoneNumber: String?) {
        findRouteService(IAudioImService::class.java).openAxbDialog(activity, type, phoneNumber)
    }

    override fun closePlayer() {

    }

    override fun showExpertDetailDialog(activity: FragmentActivity, jumpUrl: String, doctorId: String, uid: String) {
        ConfideBottomSheetDialogFragment().showBottomSheetDialog(activity, jumpUrl, doctorId, false, uid)
    }

    override fun requestConfidePermission(activity: FragmentActivity, call: ((Boolean) -> Unit)?) {
        ConfidePermissionDialog().apply { callback = call }.show(activity.supportFragmentManager, "ConfidePermissionDialog")
    }

}