package com.ydl.confide.home.popwindow

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.PopupWindow
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeFiterItemBean
import com.ydl.confide.home.popwindow.adapter.ConfideHomeSortAdapter
import kotlinx.android.synthetic.main.confide_sort_popup_window.view.*

/**
 * @author yuanwai
 * @描述:综合排序popupWindow
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/22
 */
class ConfideHomeSortPopupWindow(val context: Context, private val sortItems: ArrayList<ConfideHomeFiterItemBean>, var selectedSort: ConfideHomeFiterItemBean, private val onSortItemSelectedListener: OnSortItemSelectedListener)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {

    private var adapter: ConfideHomeSortAdapter? = null

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.confide_sort_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        val rvSortItem = view.rvSortItem
        if (null == adapter){
            adapter = ConfideHomeSortAdapter(context, sortItems, selectedSort, onSortItemSelectedListener)
            rvSortItem.adapter = adapter
            rvSortItem.layoutManager =
                LinearLayoutManager(
                    context,
                    LinearLayoutManager.VERTICAL,
                    false
                )
        }
        view.v_zhezhao.setOnClickListener {
            dismiss()
        }
    }

    fun notifyDataSetChanged() {
        adapter?.notifyDataSetChanged()
    }

    interface OnSortItemSelectedListener {
        fun onSortItemSelected(sortItem: ConfideHomeFiterItemBean)
    }
}