package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeBannerView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author yuanwai
 * @描述:banner 适配器
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10 0010
 */
class ConfideHomeBannerSection(var context: Context, private var confideHomeEvent : IConfideHomeEvent) : Section<RecyclerView.ViewHolder>(0) {
    override fun getSectionId(): Int {
        return IConfideHomeConfig.SECTION_BANNER
    }

    private var data : ConfideHomeDataBean? = null

    override fun getTotalDataNum(): Int {
        return 1
    }

    override fun getItemViewType(position: Int): Int {
        return IConfideHomeConfig.SECTION_BANNER
    }

    fun setData(data : ConfideHomeDataBean){
        this.data = data
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        return when(viewType){
        //banner
            IConfideHomeConfig.SECTION_BANNER -> {
                BannerViewHolder(ConfideHomeBannerView(context,confideHomeEvent))
            }
            else -> {
                EmptyViewHolder(View.inflate(context,R.layout.confide_view_empty,null))
            }
        }
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {
        if (holder is BannerViewHolder){
            holder.bannerView!!.initData(this.data!!)
        }
    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_BANNER.toString())
    }

    override fun isHeadType(position: Int): Boolean {
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        return false
    }


    /**
     * banner viewHolder
     */
    inner class BannerViewHolder(itemView: ConfideHomeBannerView) : RecyclerView.ViewHolder(itemView) {
        var bannerView: ConfideHomeBannerView? = null

        init {
            bannerView = itemView
        }
    }

    /**
     * 空View
     */
    inner class EmptyViewHolder(itemViews: View) :  RecyclerView.ViewHolder(itemViews) {
        private var itemViews: View? = null

        init {
            this.itemViews = itemViews
        }
    }
}