package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeRecommendExpertView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author Jim
 * @描述:最佳倾诉榜单section
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/11 0011
 */
class ConfideHomeRecommendExpertSection(var context: Context, var confideHomeEvent: IConfideHomeEvent) : Section<RecyclerView.ViewHolder>(0){


    private var data: ConfideHomeDataBean? = null
    private val HEADER = 200

    fun setData(data: ConfideHomeDataBean) {
        this.data = data
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {
        if (holder is HeadViewHolder && null != data && null != data!!.head && !TextUtils.isEmpty(this.data?.head!!.title)) {
            holder.confideHeadView.findViewById<TextView>(R.id.tv_title).text = this.data?.head!!.title
        } else if (holder is ConfideHomeRecommendExpertViewHolder) {
            holder.confideHomeRecommendExpertView.initData(this.data!!)
        }
    }

    override fun getTotalDataNum(): Int {
        var count = 0
        if (data?.head != null && !TextUtils.isEmpty(data?.head!!.title)) {
            count++
        } else if (data?.footer != null) {
            count++
        }
        return count+1
    }

    override fun getItemViewType(position: Int): Int {
        if (isHeadType(position)) {
            return combineType(IConfideHomeConfig.SECTION_CONSULTANT, this.HEADER)
        } else {
            return IConfideHomeConfig.SECTION_CONSULTANT
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        if (viewType == combineType(IConfideHomeConfig.SECTION_CONSULTANT, HEADER)) {
            return HeadViewHolder(LayoutInflater.from(context).inflate(R.layout.confide_recommend_expert_head, parent, false))
        } else {
            return ConfideHomeRecommendExpertViewHolder(ConfideHomeRecommendExpertView(context, confideHomeEvent))
        }
    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_CONSULTANT.toString())

    }


    override fun isHeadType(position: Int): Boolean {
        if (data?.head==null || TextUtils.isEmpty(data?.head!!.title)) {
            return false
        } else if (position == 0) {
            return true
        }
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        if (data?.footer == null) {
            return false
        } else if (position == totalDataNum - 1) {
            return true
        }
        return false
    }

    inner class HeadViewHolder(var confideHeadView: View) : RecyclerView.ViewHolder(confideHeadView)


    inner class ConfideHomeRecommendExpertViewHolder(var confideHomeRecommendExpertView: ConfideHomeRecommendExpertView) : RecyclerView.ViewHolder(confideHomeRecommendExpertView)

}