package com.ydl.confide.home.widget

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.event.IConfideHomeEvent
import kotlinx.android.synthetic.main.confide_item_header.view.*

@Suppress("DEPRECATION")
/**
 * @author Jim
 * @描述:倾诉首页headview
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/11 0011
 */
class ConfideHomeHeadView(context: Context, private var confideHomeEvent: IConfideHomeEvent) : LinearLayout(context) {

    init {
        initView()
    }

    private fun initView() {
        orientation = HORIZONTAL
        View.inflate(context, R.layout.confide_item_header, this)
        var params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dip2px(25f))
        params.setMargins(0, RxImageTool.dip2px(30f), 0, RxImageTool.dip2px(18f))
        layoutParams = params
    }

    fun initData(bean: ConfideHomeDataBean) {
        if (bean.head == null) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        iv_recently_more.text = bean.head.subTitle
        iv_recently_more.setOnClickListener {
            confideHomeEvent.recommendMoreClick(bean.head.subLinkUrl)
        }
        when (bean.type) {
            IConfideHomeConfig.TYPE_RECOMMEND -> {
                setPadding(0, RxImageTool.dip2px(30f), 0, 0)
                iv_recently_talk.setImageResource(R.drawable.confide_recommend)
                iv_recently_title.text = bean.head.title
                iv_recently_more.visibility = View.GONE
            }
            IConfideHomeConfig.TYPE_RECENTLY_CONFIDED -> {
                setPadding(0, RxImageTool.dip2px(30f), 0, RxImageTool.dip2px(18f))
                iv_recently_talk.setImageResource(R.drawable.confide_zuijin)
                iv_recently_title.text = bean.head.title
                iv_recently_more.visibility = View.GONE
            }
            IConfideHomeConfig.TYPE_SOUND -> {
                iv_recently_talk.setImageResource(R.drawable.confide_listen)
                iv_recently_title.text = bean.head.title
                iv_recently_more.visibility = View.GONE
            }
        }
    }
}