package com.ydl.confide.home.widget

import android.content.Context
import android.view.View
import android.widget.FrameLayout
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.adapter.RecommendExpertAdapter
import kotlinx.android.synthetic.main.confide_recommend_expert_view.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页--最佳倾诉榜单View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/21
 */
class ConfideHomeRecommendExpertView(context : Context, private var confideHomeEvent: IConfideHomeEvent) : FrameLayout(context){
    //适配器
    private var mRecommendExpertAdapter : RecommendExpertAdapter? = null
    //view缓存集合
    private var cacheViewList: List<View>? = null

    init {
        cacheViewList = ArrayList()
        initView()
    }

    companion object {
        //播放索引位置
        var playIndex = 0
    }

    private fun initView(){
        View.inflate(context, R.layout.confide_recommend_expert_view,this)
    }

    fun initData(bean: ConfideHomeDataBean?){
        if (null == bean){
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        bindView(bean)
        initAdapter()
    }

    /**
     * 创建View
     */
    private fun bindView(bean: ConfideHomeDataBean){
        var count = cacheViewList!!.size
        for (index in 0 until bean.body!!.size) {
            if (bean.body[index].confideIsPlay){
                playIndex = index
            }
            if (0 == count){
                (cacheViewList as ArrayList).add(ConfideHomeRecommendExpertItemView(context,confideHomeEvent))
            }else if (index > count - 1){
                (cacheViewList as ArrayList).add(ConfideHomeRecommendExpertItemView(context,confideHomeEvent))
            }
            if ((cacheViewList as ArrayList)[index] is ConfideHomeRecommendExpertItemView){
                ((cacheViewList as ArrayList)[index] as ConfideHomeRecommendExpertItemView).initData(bean.body[index],index)
            }
        }
    }

    /**
     * 初始化适配器
     */
    private fun initAdapter(){
        if (null == mRecommendExpertAdapter){
            mRecommendExpertAdapter = RecommendExpertAdapter(context,cacheViewList!!)
            viewPager.adapter = mRecommendExpertAdapter
            viewPager.offscreenPageLimit = cacheViewList!!.size
        }
        viewPager.currentItem = playIndex
    }
}