package com.yidianling.consultant

import android.annotation.SuppressLint
import android.view.WindowManager
import com.alibaba.android.arouter.facade.annotation.Route
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.consultant.constants.ConsultBIConstants
import com.yidianling.consultant.model.SearchApi
import com.yidianling.consultant.model.bean.ChildrenBean
import com.yidianling.consultant.router.ConsultantIn
import com.yidianling.consultant.ui.view.topView.EightCategoryView
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.consultant_layout_eight_category.*
import kotlinx.android.synthetic.main.consultant_layout_search_toolbar.*

@Route(path = "/consult/eightcategory")
class ExpertEightCategoryActivity : BaseActivity() {
    override fun layoutResId(): Int {
        return R.layout.consultant_layout_eight_category
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, true)
    }

    @SuppressLint("CheckResult")
    override fun initDataAndEvent() {
        window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE or WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN)
        showProgressDialog()
        SearchApi.getSearchApi()
            .searchEightCategoryHotWord()
            .compose(RxUtils.resultJavaData())
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({ resp ->
                dismissProgressDialog()
                var mutableList = mutableListOf<MutableList<ChildrenBean>>()
                resp.forEach {
                    it.children?.let { it1 -> mutableList.add(it1) }
                }
                mutableList.forEachIndexed { index, item ->
                    item.forEachIndexed { inin, childrenBean ->
                        if (inin < 8) {
                            childrenBean.isVisible = true
                        }
                        if (inin == 8) {
                            return@forEachIndexed
                        }
                    }
                }
                val eightCategoryView = EightCategoryView(this, true)
                eightCategoryView.setData(mutableList, null, null, true)
                eight_view_ll.addView(eightCategoryView)
            }, { t ->
                dismissProgressDialog()
            })
        btn_back.setOnClickListener {
            onBackPressed()
        }
        btn_call.setOnClickListener {
            ActionCountUtils.count(ConsultBIConstants.ConsultEvent.APP_CONSULT_LIST_ONLINE_CUSTOMER_CLICK)

            ConsultantIn.startP2PXiaoYi(this)
        }
        tv_guide.setOnClickListener {
            ActionCountUtils.count(ConsultBIConstants.ConsultEvent.APP_CONSULT_LIST_CONSULT_GUIDE_CLICK)

            val h5param = H5Params(HttpConfig.H5_URL + "help/consultation/", "咨询指南")
            h5param.isShowMenu = true
            NewH5Activity.start(this, h5param)
        }
        rl_search.setOnClickListener {
            ActionCountUtils.count(
                ConsultBIConstants.ConsultEvent.YDL_USER_CONSULT_SEARCH_CLICK,
                tv_search_content.hint.toString()
            )
            ARouter.getInstance()
                .build("/consult/hot_search")
                .withString(
                    ExpertSearchActivity.HOT_SEARCH_DOCTOR_NAME,
                    tv_search_content.text.toString()
                )
                .navigation()
        }
    }
}