package com.yidianling.consultant

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.animation.ObjectAnimator
import android.animation.PropertyValuesHolder
import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.content.Intent
import android.graphics.Typeface
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.View
import android.view.WindowManager
import android.view.inputmethod.InputMethodManager
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.alibaba.android.arouter.facade.annotation.Route
import com.alibaba.android.arouter.launcher.ARouter
import com.google.android.material.appbar.AppBarLayout
import com.tencent.mmkv.MMKV
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.config.SimpleImageOpConfiger
import com.ydl.ydl_image.listener.YDLImageRecyclerOnScrollListener
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.ydl.ydlcommon.base.BaseMvpActivity
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.ui.LogoLoadingView
import com.ydl.ydlcommon.utils.BuryPointUtils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.ydl.ydlcommon.utils.remind.ToastHelper
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.ydl.ydlcommon.view.listener.EndlessRecyclerViewScrollListener
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxImageTool
import com.yidianling.common.tools.ToastUtil
import com.yidianling.consultant.adapter.ExpertSearchAdapter
import com.yidianling.consultant.bean.ConsultantRecentCity
import com.yidianling.consultant.constants.ConsultBIConstants
import com.yidianling.consultant.constants.ConsultBIConstants.ConsultEvent.Companion.POPUP_ICON_CLICK
import com.yidianling.consultant.constants.ConsultBIConstants.ConsultEvent.Companion.PRICE_TYPE_CLICK
import com.yidianling.consultant.constants.ConsultBIConstants.ConsultEvent.Companion.YDL_USER_CONSULT_SEARCH_CLICK
import com.yidianling.consultant.listener.OnCategoriesSelectedListener
import com.yidianling.consultant.listener.OnFilterConfirmListener
import com.yidianling.consultant.listener.OnPriceItemSelectedListener
import com.yidianling.consultant.listener.OnSortItemSelectedListener
import com.yidianling.consultant.model.SearchApi
import com.yidianling.consultant.model.bean.*
import com.yidianling.consultant.modular.singlton.ConsultAssistantDialogUtils
import com.yidianling.consultant.router.ConsultantIn
import com.yidianling.consultant.ui.view.*
import com.yidianling.consultant.ui.view.topView.RecommendListView
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.consultant_activity_expert_search_list.*
import kotlinx.android.synthetic.main.consultant_item_filter_online.view.*
import kotlinx.android.synthetic.main.consultant_layout_search_content.*
import kotlinx.android.synthetic.main.consultant_layout_search_toolbar.*
import org.json.JSONObject
import java.util.concurrent.Executors
import java.util.concurrent.TimeUnit


@Route(path = "/consult/list")
class ExpertSearchActivity : BaseMvpActivity<IExpertSearchView, ExpertSearchPresenter>(),
    View.OnClickListener, IExpertSearchView,
    OnCategoriesSelectedListener, OnSortItemSelectedListener, OnFilterConfirmListener,
    SwipeRefreshLayout.OnRefreshListener, OnPriceItemSelectedListener {
    var bottomWordDisposable: Disposable? = null
    private lateinit var bottomWordlist: List<FunctionWordBean>
    private var searchWord: String? = ""
    private var subLocationItem: SubItem? = SubItem()
    private var locationRegionItem: RegionItem? = null
    private var locationList: ArrayList<SubItem>? = arrayListOf()
    private var locationHistoryList: ArrayList<RegionItem>? = arrayListOf()
    private var eightcategoryPopup: EightCategoryPopupWindow? = null

    override fun showImage(url: String?, imgView: ImageView) {
        YDLImageCacheManager.showImage(ExpertSearchActivity@ this, url, imgView)
    }

    override fun showImage(url: String?, imgView: ImageView, ops: SimpleImageOpConfiger) {
        YDLImageCacheManager.showImage(this, url, imgView, ops)
    }

    override fun showPromptPayment(promptPaymentBean: PromptPaymentBean) {
    }

    override fun showImage(
        url: String?,
        imgView: ImageView,
        width: Int,
        heigh: Int,
        ops: SimpleImageOpConfiger
    ) {
        YDLImageCacheManager.showImage(ExpertSearchActivity@ this, url, imgView, width, heigh, ops)
    }

    override fun layoutResId(): Int {
        return R.layout.consultant_activity_expert_search_list
    }

    override fun initDataAndEvent() {
        window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE or WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN)
        initViews()
        initData(intent, false)

        rl_hot_fix_for_huawei.visibility = View.VISIBLE
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, true)
    }

    companion object {
        const val GO_CRITERIA = "go_criteria"
        const val EXTRA_CATEGORY = "category"
        const val EXTRA_CATEGORY_NAME = "category_name"
        const val EXTRA_SHOW_TYPE = "showType"
        const val EXTRA_FROM_PAGE = "fromPage"
        const val CATEID3IN = "cateid3in"
        const val HOT_SEARCH_DOCTOR_NAME = "hot_search_doctor_name"
        private const val EXTRA_IS_SHOW_HOT = "isInitShowHot"
        private const val EXTRA_SEARCH_WORD = "searchWord"
        private const val EXTRA_RELATED_WORD = "related_word"
        private const val EXTRA_IS_RECCOMMEND_WORD = "is_reccommend_word"
        private const val EXTRA_IS_FROM_SPLASH = "isFromSplash"
        private const val FILTER_STATUS_NORMAL = 0 //默认筛选状态
        private const val FILTER_STATUS_FILTERED = 1 //非默认筛选状态
        private const val FILTER_STATUS_OPEN = 2 //筛选窗打开状态
        private const val CONST_CITY = "城市"
        const val FROM_ONLINE_EXPERT = 2

        fun newIntent(
            activity: Activity,
            category: String,
            showType: Int,
            isInitShowHot: Boolean
        ): Intent {
            val intent = Intent(activity, ExpertSearchActivity::class.java)
            intent.putExtra(EXTRA_CATEGORY, category)
            intent.putExtra(EXTRA_SHOW_TYPE, showType)
            intent.putExtra(EXTRA_IS_SHOW_HOT, isInitShowHot)
            return intent
        }

        fun start(context: Context, category: String) {
            val intent = Intent(context, ExpertSearchActivity::class.java)
            intent.putExtra(EXTRA_CATEGORY, category)
            context.startActivity(intent)
        }

        fun start(context: Context, category: String, categoryName: String, showType: Int) {
            val intent = Intent(context, ExpertSearchActivity::class.java)
            intent.putExtra(EXTRA_CATEGORY, category)
            intent.putExtra(EXTRA_CATEGORY_NAME, categoryName)
            intent.putExtra(EXTRA_SHOW_TYPE, showType)
            context.startActivity(intent)
        }

        /**
         * 搜索页面过来的
         * @param sign2为14 仅用于埋点
         * @param relatedWord 搜索内容的关联词
         * @param isRecommendWords 是否是推荐词
         */
        fun startSearch(
            context: Context,
            searchWord: String?,
            sign2: String,
            relatedWord: String,
            isRecommendWords: Boolean
        ) {
            val intent = Intent(context, ExpertSearchActivity::class.java)
            intent.putExtra(EXTRA_SEARCH_WORD, searchWord)
            intent.putExtra(EXTRA_RELATED_WORD, relatedWord)
            intent.putExtra(EXTRA_IS_RECCOMMEND_WORD, isRecommendWords)
            intent.putExtra("sign2", sign2)
            context.startActivity(intent)
        }

        fun start(context: Context, category: String, showType: Int, isFromSplash: Boolean) {
            val intent = Intent(context, ExpertSearchActivity::class.java)
            intent.putExtra(EXTRA_CATEGORY, category)
            intent.putExtra(EXTRA_SHOW_TYPE, showType)
            intent.putExtra(EXTRA_IS_FROM_SPLASH, isFromSplash)
            context.startActivity(intent)
        }

        fun start(context: Context, isShowHot: Boolean, fromPageType: Int) {
            val intent = Intent(context, ExpertSearchActivity::class.java)
            intent.putExtra(EXTRA_IS_SHOW_HOT, isShowHot)
            intent.putExtra(EXTRA_FROM_PAGE, fromPageType)
            context.startActivity(intent)
        }

        fun start(context: Context) {
            val intent = Intent(context, ExpertSearchActivity::class.java)
            context.startActivity(intent)
        }
    }

    private val allFilter = AllFilter() //当前筛选
    private val tempFilter = AllFilter() //临时筛选，未确认状态
    private var curPage = 1
    private val doctorList = ArrayList<ExpertServiceItem>()
    private var hasMore = true
    private var initCategory = "0"
    private var hasCateid = "0"
    private var initCategoryCateid3 = "0"
    private var initShowType: Int = 1

    var mapFilter: Map<String, Any>? = null
    private lateinit var doctorAdapter: ExpertSearchAdapter
    private lateinit var onScrollListener: EndlessRecyclerViewScrollListener
    private var headData: HeadData? = null //筛选数据
    private var isFromSplash = false
    private val props1 = JSONObject() //筛选标题埋点参数
    private var fromPageType: Int = 1 //从哪个页面跳转过来的
    private var isRecommend = false //埋点数据
    private var cateName: String? = null
    private var mSign2: String = ""  // 用于搜索页面进来的埋点参数
    private var isDoSearch: Boolean = false //埋点判断是否通过搜索进入埋点的
    private var hasSelectedArea = false  //是否选择过地区
    private var hasSelectedSort = false  //是否选择过排序


    override fun createPresenter(): ExpertSearchPresenter = ExpertSearchPresenter()

    private fun initViews() {
        srlContainer.isEnabled = true
        tvSubject.setOnClickListener(this)
        tvArea.setOnClickListener(this)
        tvSort.setOnClickListener(this)
        tvFilter.setOnClickListener(this)
        btn_call.setOnClickListener(this)
        tv_guide.setOnClickListener(this)
        rl_search.setOnClickListener(this)
        srlContainer.setColorSchemeColors(ContextCompat.getColor(this, R.color.platform_main_theme))
        srlContainer.setProgressViewOffset(false, 0, 200)
        srlContainer.setOnRefreshListener(this)

        recommendListView.addViewPagerScrollStateListener(object :
            RecommendListView.ViewPagerScrollStateCallback {
            override fun viewPagerScroll(isScrolling: Boolean) {
                //如果viewpager正在滚动，则禁止下拉刷新
                srlContainer.isEnabled = !isScrolling
            }
        })

        appbar_layout.addOnOffsetChangedListener(AppBarLayout.OnOffsetChangedListener { _, i ->
            srlContainer.isEnabled = i >= 0
        })
        initNetLossView()


        btn_back.setOnClickListener {
            onBackPressed()
        }
        doctorAdapter = ExpertSearchAdapter(this, this, doctorList)
        val layoutManager = LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false)
        rvExperts.layoutManager = layoutManager
        rvExperts.adapter = doctorAdapter
        doctorAdapter.setOnClickLister(object : ExpertSearchAdapter.OnClickLister {
            override fun onClick(searchWords: String) {
                allFilter.searchWord = searchWords

                refresh(false)
            }

        })
        onScrollListener = object : EndlessRecyclerViewScrollListener(layoutManager) {
            private var isBtnShow: Boolean = false
            private var sIsScrolling = false
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                hideSoftInput()
                if (newState == RecyclerView.SCROLL_STATE_DRAGGING || newState == RecyclerView.SCROLL_STATE_SETTLING) {
                    //滚动
                    ConsultAssistantDialogUtils.INSTANCE.hideAssistantActivity()
                    sIsScrolling = true
                    if (!this@ExpertSearchActivity.isFinishing) {
//                        GlideApp.with(this@ExpertSearchActivity).pauseRequests()
                    }
                } else if (newState == RecyclerView.SCROLL_STATE_IDLE) {
                    //没有滚动
                    ConsultAssistantDialogUtils.INSTANCE.fitRequest(
                        this@ExpertSearchActivity,
                        "doctor_list",
                        true
                    )
                    if (sIsScrolling) {
                        if (!this@ExpertSearchActivity.isFinishing) {
//                            GlideApp.with(this@ExpertSearchActivity).resumeRequests()
                        }
                    }
                    sIsScrolling = false;
                }
            }

            override fun onScrollTop() {
                val alpha = PropertyValuesHolder.ofFloat("alpha", 1f, 0f)
                val scaleX = PropertyValuesHolder.ofFloat("scaleX", 1f, 0f)
                val scaleY = PropertyValuesHolder.ofFloat("scaleY", 1f, 0f)
                val animator =
                    ObjectAnimator.ofPropertyValuesHolder(image_scroll_top, alpha, scaleX, scaleY)
                        .setDuration(200)
                animator.addListener(object : AnimatorListenerAdapter() {
                    override fun onAnimationEnd(animation: Animator) {
                        image_scroll_top.visibility = View.GONE
                        isBtnShow = false
                    }
                })
                animator.start()
            }

            override fun onScrollDown() {
                if (isBtnShow) {
                    return
                }
                val alpha = PropertyValuesHolder.ofFloat("alpha", 0f, 1f)
                val scaleX = PropertyValuesHolder.ofFloat("scaleX", 0f, 1f)
                val scaleY = PropertyValuesHolder.ofFloat("scaleY", 0f, 1f)
                val animator =
                    ObjectAnimator.ofPropertyValuesHolder(image_scroll_top, alpha, scaleX, scaleY)
                        .setDuration(200)
                animator.addListener(object : AnimatorListenerAdapter() {
                    override fun onAnimationEnd(animation: Animator) {
                        image_scroll_top.visibility = View.VISIBLE
                        isBtnShow = true
                    }
                })
                animator.start()
            }

            override fun onScrollUp() {
                if (!isBtnShow) {
                    return
                }
                val alpha = PropertyValuesHolder.ofFloat("alpha", 1f, 0f)
                val scaleX = PropertyValuesHolder.ofFloat("scaleX", 1f, 0f)
                val scaleY = PropertyValuesHolder.ofFloat("scaleY", 1f, 0f)
                val animator =
                    ObjectAnimator.ofPropertyValuesHolder(image_scroll_top, alpha, scaleX, scaleY)
                        .setDuration(200)
                animator.addListener(object : AnimatorListenerAdapter() {
                    override fun onAnimationEnd(animation: Animator) {
                        image_scroll_top.visibility = View.GONE
                        isBtnShow = false
                    }
                })
                animator.start()
            }

            override fun onLoadMore(page: Int, totalItemsCount: Int, view: RecyclerView?) {
                if (hasMore) {
                    getPresenter().fetchListData(allFilter, getPresenter().mExtras, mapFilter)
                }
            }
        }
        rvExperts.addOnScrollListener(onScrollListener)
        rvExperts.addOnScrollListener(YDLImageRecyclerOnScrollListener(ExpertSearchActivity@ this))
        image_scroll_top.setOnClickListener(this)
//        initStatus()

        ConsultAssistantDialogUtils.INSTANCE.fitRequest(this, "doctor_list", true)
    }

    private fun initNetLossView() {
        v_loading.setListener(object : LogoLoadingView.LogoLoadingListener {
            override fun onDataResetClick() {
                rvExperts.visibility = View.GONE
                v_loading.visibility = View.VISIBLE
                ll_network_error.visibility = View.GONE
                v_loading.setViewType(LogoLoadingView.TYPE_LOADING, null)
                refresh(false)
            }

            override fun onBackClick() {
                finish()
            }
        })
    }

    override fun localData() {
    }

    //路由传递过来的参数
    private fun getRouterParam() {
        if (null != intent && intent.hasExtra("routerParam")) {
            val params = intent.getStringExtra("routerParam")
            val paramsJson = JSONObject(params)
            initCategory = paramsJson.getString("cateId")
            cateName = paramsJson.getString("cateTitle")
            mSign2 = cateName!!
            initShowType = paramsJson.getString("showType").toInt()
        }
    }

    private fun initData(mIntent: Intent, isRefresh: Boolean) {
        fromPageType = mIntent.getIntExtra(EXTRA_FROM_PAGE, -1)
        initCategory = mIntent.getStringExtra(EXTRA_CATEGORY) ?: "0"
        initShowType = mIntent.getIntExtra(EXTRA_SHOW_TYPE, 0)
        //首页金刚位传递过来的动态Map参数
        if (mIntent.getSerializableExtra(GO_CRITERIA) != null) {
            mapFilter = mIntent.getSerializableExtra(GO_CRITERIA) as HashMap<String, Any>
        }
        initCategory = mIntent.getStringExtra("cateId") ?: ""
        initCategoryCateid3 = mIntent.getStringExtra(CATEID3IN) ?: ""


        if (!TextUtils.isEmpty(initCategoryCateid3) && initCategoryCateid3 != "0") {
            allFilter.categoryId3List.add(initCategoryCateid3)
        }
        if (mIntent.getStringExtra("cateTitle") != null) {
            cateName = mIntent.getStringExtra("cateTitle")
        }
        mSign2 = cateName.toString()
        val relatedWord = mIntent.getStringExtra(EXTRA_RELATED_WORD)       // 搜索内容的联想词
        searchWord = mIntent.getStringExtra(EXTRA_SEARCH_WORD)
        val isRecommendWords = mIntent.getBooleanExtra(EXTRA_IS_RECCOMMEND_WORD, false)
        if (!TextUtils.isEmpty(relatedWord)) {      // 判断搜索内容的联想词为空，则用搜索词进行搜索
            allFilter.searchWord = relatedWord
        } else {
            allFilter.searchWord = searchWord
        }
        mSign2 = mIntent.getStringExtra("sign2") ?: ""
//        getRouterParam()

        allFilter.showType.key = initShowType
        if (!TextUtils.isEmpty(initCategory) && initCategory != "0") {
            allFilter.categoryId2List.add(initCategory)
        }

        getPresenter().fetchListHead()
        recommendListView.requestData(initCategory)
        if (isRefresh) {
            refresh(false)
        }

        tv_search_content.text = searchWord
        // 判断搜索词和联想词不一样，则显示匹配结果
        LogUtil.e("searchWord:${searchWord}")
        LogUtil.e("relatedWord:${relatedWord}")
        if (!TextUtils.isEmpty(searchWord) && !TextUtils.isEmpty(relatedWord) && searchWord != relatedWord) {
            if (doctorList.size > 0 && doctorList[0].is_head_view) {
                doctorList[0] = ExpertServiceItem(true, searchWord.toString(), relatedWord)
            } else if (doctorList.size > 0) {
                doctorList.add(0, ExpertServiceItem(true, searchWord.toString(), relatedWord))
            } else {
                doctorList.add(ExpertServiceItem(true, searchWord.toString(), relatedWord))
            }
        } else {
            if (doctorList.size > 0 && doctorList[0].is_head_view) {
                doctorList.removeAt(0)
            }
        }

        v_loading.visibility = View.VISIBLE
        v_loading.setViewType(LogoLoadingView.TYPE_LOADING, null)
        hasCateid = mIntent.getStringExtra(IYDLRouterConstant.HASCATEID) ?: ""
        doctorAdapter.clickCount = 0
        doctorAdapter.setIsRecommendWords(isRecommendWords)
        doctorAdapter.setEntrance(1)
        getPresenter().fetchFunctionWord(2)
    }

    private fun hasCateid() {
        //金刚位传递过来的cateid 如果八大分类 contain这个cateid就显示。否则不显示。
        val mutableList = mutableListOf<MutableList<ChildrenBean>>()
        mutableList.add(allFilter.childList)
        mutableList.add(allFilter.stressList)
        mutableList.add(allFilter.loveEmotionList)
        mutableList.add(allFilter.marriedFamilyList)
        mutableList.add(allFilter.personalGrowthList)
        mutableList.add(allFilter.interpersonalRelationshipList)
        mutableList.add(allFilter.careerDevelopmentList)
        mutableList.add(allFilter.mentalHealthList)
        var isShow = false
        mutableList.forEachIndexed { index, item ->
            if (item[0].cate_id == hasCateid) {
                item[0].isSelected = true
                isShow = true
            }
        }
        if (isShow) {
            if (!TextUtils.isEmpty(cateName)) {
                tvSubject.text = cateName
                updateFilterTextViewStatus(tvSubject, FILTER_STATUS_FILTERED)
            }
        } else {
            tvSubject.text = "困扰"
            updateFilterTextViewStatus(tvSubject, FILTER_STATUS_NORMAL)
        }

    }

    override fun onNewIntent(intent: Intent?) {
        super.onNewIntent(intent)
        initData(intent!!, true)
    }


    //返回键处理，热门搜索如果可见，则隐藏，来自启动页，则打开主界面
    override fun onBackPressed() {
        if (isFromSplash) {
            ConsultantIn.mainIntent(this)
        }
        finish()
    }


    //获取筛选数据
    override fun onHeadFetched(headData: HeadData?) {
        //头部数据获取到后初始化筛选数据
        this.headData = headData
        headData?.let { it ->
//            allFilter.reorder = it.reorder[0]
            allFilter.showType = it.filters.showType[initShowType]
            if (it.highlighter.size > 0) {
                //设置热门搜索
                initHotViews(lin_filter2, it.highlighter)
            }
            it.cates[0].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.childList.add(childrenBean)
            }
            it.cates[1].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.stressList.add(childrenBean)
            }
            it.cates[2].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.loveEmotionList.add(childrenBean)
            }
            it.cates[3].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.marriedFamilyList.add(childrenBean)
            }
            it.cates[4].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.personalGrowthList.add(childrenBean)
            }
            it.cates[5].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.interpersonalRelationshipList.add(childrenBean)
            }
            it.cates[6].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.careerDevelopmentList.add(childrenBean)
            }
            it.cates[7].children?.forEachIndexed { index, children ->
                val type = if (children.cate_name.length > 4) 2 else 1
                val childrenBean =
                    ChildrenBean(children.cate_name, children.cate_id, index <= 12, type)
                allFilter.mentalHealthList.add(childrenBean)
            }
        }
        hasCateid()
    }

    override fun onFunctionWordFetched(wordBean: MutableList<FunctionWordBean>) {
        //获取底纹词
        bottomWordlist = wordBean
        if (bottomWordlist.isNullOrEmpty()) return
        if (!searchWord.isNullOrEmpty()) {
            tv_search_content.text = searchWord
        } else {
            if (bottomWordlist.size == 1) {
                tv_search_content.text = bottomWordlist[0].word
            } else {
                bottomWordDisposable = Observable.interval(0, 3, TimeUnit.SECONDS)
                    .subscribeOn(Schedulers.computation())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe({
                        tv_search_content.text =
                            bottomWordlist[(it % bottomWordlist.size).toInt()].word
                    }, {
                    }, {

                    })
            }
        }
    }

    /**
     * 热门
     */
    private fun initHotViews(view: LinearLayout, hotData: List<HighlighterItem>) {
        if (view.childCount > 0) {
            return
        }
        for (hot in hotData) {
            val tv =
                View.inflate(mContext, R.layout.consultant_item_filter_online, null) as TextView
            val textView = tv.tvFree
            val params = LinearLayout.LayoutParams(0, RxImageTool.dp2px(22f))
            params.weight = 1f
            params.setMargins(0, 0, RxImageTool.dp2px(10f), 0)
            textView.layoutParams = params

            textView.text = hot.value
            textView.setOnClickListener {
                if (textView.isSelected) {
                    dealHotSelect(hot, false)
                    textView!!.isSelected = false
                    textView.paint.isFakeBoldText = false
                } else {
                    dealHotSelect(hot, true)
                    textView.isSelected = true
                    textView.paint.isFakeBoldText = true
                    // 埋点
                    ActionCountUtils.baiDuCountSign3(
                        ConsultBIConstants.PART_ID_CONSULT_COUNSELOR_LIST_PAGE,
                        ConsultBIConstants.ConsultEvent.POSITION_CHOICE_FILTER_CLICK,
                        hot.value!!,
                        "app",
                        ""
                    )
                }
                filterLabelSet()
                //开始筛选数据
                refresh()
            }
            view.addView(textView)
        }
    }


    /**
     * 处理热门搜索的选中逻辑
     * * 1：主题
     * 2：省
     * 3：排序
     * 4：咨询方式
     * 5：年龄选择
     * 6：其他选择
     * 7：资质选择
     * 8.市
     *
     * @param isAdd 是否是添加
     */
    private fun dealHotSelect(hotData: HighlighterItem, isAdd: Boolean) {
        when (hotData.type) {
            "1" -> {
//                if (headData?.cates!!.size > 0) {
//                    for (bean in headData?.cates!!) {
//                        if (TextUtils.equals(hotData.id, bean.cateId.toString())) {
//                            if (isAdd) {
//                                if (allFilter.categories.size == 1 && allFilter.categories[0].cateId == "0") {
//                                    allFilter.categories.clear()
//                                }
//                                allFilter.categories.add(bean)
//                                updateFilterTextViewStatus(tvSubject, FILTER_STATUS_FILTERED)
//                            } else {
//                                allFilter.categories.remove(bean)
//                                if (allFilter.categories.size == 0) {
//                                    allFilter.categories.add(headData?.cates?.get(0) ?: CateItem())
//                                    updateFilterTextViewStatus(tvSubject, FILTER_STATUS_NORMAL)
//                                }
//                            }
//                        }
//                    }
//                    if (allFilter.categories.size == 1 && "全部" != allFilter.categories[0].cateName) {
//                        //显示选中标题
//                        tvSubject.text = allFilter.categories[0].cateName
//                    } else {
//                        //显示主标题
//                        tvSubject.text = "主题"
//                    }
//                }
                updateFilterTextViewStatus(tvSubject, FILTER_STATUS_FILTERED)
            }
            "2" -> {//省
                if (headData?.region!!.size > 0) {
                    val bean = RegionItem()
                    if (isAdd) {
                        //热门中如果选择过地区、要把其他已选中的置位未选中
                        if (hasSelectedArea) {
                            for ((index, bean) in headData!!.highlighter.withIndex()) {
                                if (bean.type == "2" || bean.type == "8") {
                                    val textview = lin_filter2.getChildAt(index) as TextView
                                    textview.isSelected = false
                                    textview.paint.isFakeBoldText = false
                                }
                            }
                        }
                        bean.code = hotData.id
                        bean.value = hotData.value
                        for (headBean in headData!!.region) {
                            if (TextUtils.equals(headBean.code, bean.code)) {
                                bean.sub = headBean.sub
                                break
                            }
                        }
                        allFilter.region = bean
                        if (allFilter.region.value?.length ?: 0 > 4) {
                            tvArea.text = allFilter.region.value?.substring(0, 3) + "..."
                        } else {
                            tvArea.text = allFilter.region.value
                        }
                        updateFilterTextViewStatus(tvArea, FILTER_STATUS_FILTERED)

                        hasSelectedArea = true
                    } else {
                        allFilter.region = RegionItem()
                        tvArea.text = "地区"
                        updateFilterTextViewStatus(tvArea, FILTER_STATUS_NORMAL)

                        hasSelectedArea = false
                    }
                    allFilter.sub = SubItem("不限", null)
                }
            }
            "3" -> {
                //排序
                if (headData?.reorder!!.size > 0) {
                    for (bean in headData?.reorder!!) {
                        if (TextUtils.equals(hotData.id, bean.key.toString())) {
                            if (isAdd) {
                                if (hasSelectedSort) {
                                    for ((index, bean) in headData!!.highlighter.withIndex()) {
                                        if (bean.type == "3") {
                                            var textview = lin_filter2.getChildAt(index) as TextView
                                            textview.isSelected = false
                                            textview.paint.isFakeBoldText = false
                                        }
                                    }
                                }
                                allFilter.reorder = bean
                                updateFilterTextViewStatus(tvSort, FILTER_STATUS_FILTERED)

                                hasSelectedSort = true
                            } else {
                                allFilter.reorder = headData?.reorder?.get(0) ?: ReorderItem()
                                updateFilterTextViewStatus(tvSort, FILTER_STATUS_NORMAL)

                                hasSelectedSort = false
                            }
                        }
                    }
                    when {
                        allFilter.reorder.value.equals("综合排序") -> tvSort.text = "排序"
                        allFilter.reorder.value?.length ?: 0 > 4 -> tvSort.text =
                            allFilter.reorder.value?.substring(0, 3) + "..."
                        else -> tvSort.text = allFilter.reorder.value
                    }
                }
            }
            "4" -> {
                //咨询方式
                if (headData?.filters?.enquiry!!.isNotEmpty()) {
                    for (bean in headData?.filters?.enquiry!!) {
                        if (TextUtils.equals(hotData.id, bean.key.toString())) {
                            if (isAdd) {
                                allFilter.enquiries.add(bean)
                            } else {
                                allFilter.enquiries.remove(bean)
                            }
                        }
                    }
                }
                if (allFilter.others.size + allFilter.enquiries.size + allFilter.ages.size + allFilter.doctorEdu.size + allFilter.title.size > 0) {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_FILTERED)
                } else {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_NORMAL)
                }
                filterLabelSet()
            }
            "5" -> {
                //年龄选择
                if (headData?.filters?.age!!.isNotEmpty()) {
                    for (bean in headData?.filters?.age!!) {
                        if (TextUtils.equals(hotData.id, bean.key.toString())) {
                            if (isAdd) {
                                allFilter.ages.add(bean)
                            } else {
                                allFilter.ages.remove(bean)
                            }
                        }
                    }
                }
                if (allFilter.others.size + allFilter.enquiries.size + allFilter.ages.size + allFilter.doctorEdu.size + allFilter.title.size > 0) {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_FILTERED)
                } else {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_NORMAL)
                }
                filterLabelSet()
            }
            "6" -> {
                //其他选择
                if (headData?.filters?.other!!.isNotEmpty()) {
                    for (bean in headData?.filters?.other!!) {
                        if (TextUtils.equals(hotData.id, bean.key.toString())) {
                            if (isAdd) {
                                allFilter.others.add(bean)
                            } else {
                                allFilter.others.remove(bean)
                            }
                        }
                    }
                }
                if (allFilter.others.size + allFilter.enquiries.size + allFilter.ages.size + allFilter.doctorEdu.size + allFilter.title.size > 0) {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_FILTERED)
                } else {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_NORMAL)
                }
                filterLabelSet()
            }
            "7" -> {
                //资质选择
                if (headData?.filters?.title!!.isNotEmpty()) {
                    for (bean in headData?.filters?.title!!) {
                        if (TextUtils.equals(hotData.id, bean.key.toString())) {
                            if (isAdd) {
                                allFilter.title.add(bean)
                            } else {
                                allFilter.title.remove(bean)
                            }
                        }
                    }
                }
                if (allFilter.others.size + allFilter.enquiries.size + allFilter.ages.size + allFilter.doctorEdu.size + allFilter.title.size > 0) {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_FILTERED)
                } else {
                    updateFilterTextViewStatus(tvFilter, FILTER_STATUS_NORMAL)
                }
                filterLabelSet()
            }
            "8" -> {
                //市
                if (headData?.region!!.size > 0) {
                    val bean = SubItem()
                    if (isAdd) {
                        //热门中如果选择过地区、要把其他已选中的置位未选中
                        if (hasSelectedArea) {
                            for ((index, bean) in headData!!.highlighter.withIndex()) {
                                if (bean.type == "2" || bean.type == "8") {
                                    var textview = lin_filter2.getChildAt(index) as TextView
                                    textview.isSelected = false
                                    textview.paint.isFakeBoldText = false
                                }
                            }
                        }

                        bean.code = hotData.id
                        bean.value = hotData.value
                        for (headBean in headData!!.region) {
                            if (TextUtils.equals(
                                    headBean.code!!.substring(0, 2),
                                    bean.code!!.substring(0, 2)
                                )
                            ) {
                                allFilter.region = headBean
                                break
                            }
                        }
                        allFilter.sub = bean
                        if (allFilter.sub.value?.length ?: 0 > 4) {
                            tvArea.text = allFilter.sub.value?.substring(0, 3) + "..."
                        } else {
                            tvArea.text = allFilter.sub.value
                        }
                        updateFilterTextViewStatus(tvArea, FILTER_STATUS_FILTERED)

                        hasSelectedArea = true
                    } else {
                        allFilter.region = RegionItem()
                        allFilter.sub = SubItem("不限", null)

                        tvArea.text = "地区"
                        updateFilterTextViewStatus(tvArea, FILTER_STATUS_NORMAL)

                        hasSelectedArea = false
                    }
                }
            }
        }
    }


    //用于侧滑筛选过来更新快捷筛选选中状态
    private fun updateOtherViews(otherData: List<OtherItem>) {
        if (lin_filter2.childCount > 0) {
            //清空选中
            for (i in 0.until(lin_filter2.childCount)) {
                val textView = lin_filter2.getChildAt(i) as TextView
                textView.isSelected = false
                textView.paint.isFakeBoldText = false
            }
            //重置选中状态
            for (other in otherData) {
                for (i in 0 until lin_filter2.childCount) {
                    val textView = lin_filter2.getChildAt(i) as TextView
                    if (textView.text == other.value) {
                        textView.isSelected = true
                        textView.paint.isFakeBoldText = true
                    }
                }
            }
        }
    }

    /**
     * 获取专家列表数据
     */
    override fun onDoctorListFetched(
        data: MutableList<ExpertServiceItem>,
        extras: Extras?,
        curPage: Int
    ) {
        if (rvExperts.adapter != doctorAdapter) {
            rvExperts.adapter = doctorAdapter
        }

        // 如果是第一页
        if (curPage == 1) {
            if (data.size >= 10) {
                hasMore = true
                doctorAdapter.hasMore = true
            } else {
                hasMore = false
                doctorAdapter.hasMore = false
            }
            if (doctorList.size > 0 && doctorList[0].is_head_view) {
                val expertServiceItem = doctorList[0]
                doctorList.clear()
                doctorList.add(expertServiceItem)
            } else {
                doctorList.clear()
            }
        }

        if (data.size == 0) {     // data的长度为0的时候为最后一页
            hasMore = false
            doctorAdapter.hasMore = false
        } else {
            doctorList.addAll(data)
        }
        doctorAdapter.notifyDataSetChanged()
        isDoSearch = false
        isRecommend = false


        v_loading.visibility = View.GONE
        ll_network_error.visibility = View.GONE

        rvExperts.visibility = View.VISIBLE
        srlContainer.isRefreshing = false

        // 埋点
        val sign1 = data.joinToString(",") { it.id }
        ActionCountUtils.baiDuCountSign3(
            ConsultBIConstants.PART_ID_CONSULT_COUNSELOR_LIST_PAGE,
            ConsultBIConstants.POSITION_CONSULT_COUNSELOR_LIST_PAGE_VISIT,
            sign1,
            mSign2,
            "app"
        )
    }

    override fun fetchListFailed(msg: String?) {
        isDoSearch = false
        isRecommend = false

        if (curPage == 1) {
            v_loading.setViewType(
                LogoLoadingView.TYPE_NET_LOSS,
                getString(R.string.consultant_reload_hint)
            )
            v_loading.visibility = View.VISIBLE

            ll_network_error.visibility = View.GONE
        } else {
            ToastHelper.show("网络不给力")
        }
        dismissProgressDialog()
        srlContainer.isRefreshing = false
    }

    override fun fetchListEmpty(msg: String?) {
        isDoSearch = false
        isRecommend = false

        if (doctorList.size > 0 && doctorList[0].is_head_view) {
            val expertServiceItem = doctorList[0]
            doctorList.clear()
            doctorList.add(expertServiceItem)
            doctorAdapter.notifyDataSetChanged()

            v_loading.visibility = View.GONE
            ll_network_error.visibility = View.GONE

            rvExperts.visibility = View.VISIBLE
        } else {
            tv_reload.visibility = View.GONE
            tv_reload_hint.text = msg
            ll_network_error.visibility = View.VISIBLE
            iv_exception.setImageResource(R.drawable.platform_ico_img_zixun_empty)

            rvExperts.visibility = View.GONE
            dismissProgressDialog()
            srlContainer.isRefreshing = false
        }

    }

    override fun fetchFailed(msg: String?) {
        isDoSearch = false
        isRecommend = false
        if (msg != null) {
            ToastUtil.toastShort(msg)
        }
        v_loading.setViewType(
            LogoLoadingView.TYPE_NET_LOSS,
            getString(R.string.consultant_reload_hint)
        )
        v_loading.visibility = View.VISIBLE

        ll_network_error.visibility = View.GONE

        rvExperts.visibility = View.GONE
        appbar_layout.setExpanded(false)
        dismissProgressDialog()
    }

    override fun showRefreshLayout() {
        srlContainer.isRefreshing = true
    }


    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.image_scroll_top -> {
                scrollToTop()
            }
            R.id.tvSubject -> {
                props1.put("filtrate_first", "主题")
                hideSoftInput()
                appbar_layout.setExpanded(false)
                appbar_layout.postDelayed({
//                    showSubjectPopupWindow()
                    showeightCategoryPopupWindow()
                }, 300)

            }
            R.id.tvArea -> {
                props1.put("filtrate_first", "地区")
                hideSoftInput()
                appbar_layout.setExpanded(false)
                appbar_layout.postDelayed({
                    if (MMKV.defaultMMKV()
                            .decodeBool(ConsultBIConstants.ConsultantLocationAuth.WHETHER_LOCATION_AUTH)
                    ) {
                        //同意定位授权
                        showAreaPopupWindow(true)
                    } else if (MMKV.defaultMMKV()
                            .decodeBool(ConsultBIConstants.ConsultantLocationAuth.REFUSE_ALREADY)
                    ) {
                        showAreaPopupWindow(false)
                    } else {
                        val dialog = CommonDialog(mContext)
                            .setTitle("温馨提示")
                            .setMessage("建议您授权定位权限，就能轻松获取周边优秀咨询师和其他服务")
                            .setLeftOnclick("暂不") { v1 ->
                                ActionCountUtils.count(
                                    POPUP_ICON_CLICK,
                                    "暂不"
                                )
                                MMKV.defaultMMKV().encode(
                                    ConsultBIConstants.ConsultantLocationAuth.REFUSE_ALREADY,
                                    true
                                )
                                showAreaPopupWindow(false)
                            }.setRightClick("授权") { v12 ->
                                ActionCountUtils.count(
                                    POPUP_ICON_CLICK,
                                    "授权"
                                )
                                MMKV.defaultMMKV().encode(
                                    ConsultBIConstants.ConsultantLocationAuth.WHETHER_LOCATION_AUTH,
                                    true
                                )
                                showAreaPopupWindow(true)
                            }
                        dialog.show()
                    }
                }, 300)

            }
            R.id.tvSort -> {
                props1.put("filtrate_first", "排序")
                hideSoftInput()
                appbar_layout.setExpanded(false)
                appbar_layout.postDelayed({
                    updateFilterTextViewStatus(tvSort, FILTER_STATUS_OPEN)
                    ActionCountUtils.count(PRICE_TYPE_CLICK)
                    showPricePopupWindow()
                }, 300)

            }
            R.id.tvFilter -> {
                props1.put("filtrate_first", "筛选")
                hideSoftInput()
                appbar_layout.setExpanded(false)
                appbar_layout.postDelayed({
                    showFilterPopupWindow()
                }, 300)

            }
            R.id.tv_guide -> {
                ActionCountUtils.count(ConsultBIConstants.ConsultEvent.APP_CONSULT_LIST_CONSULT_GUIDE_CLICK)

                val h5param = H5Params(HttpConfig.H5_URL + "help/consultation/", "咨询指南")
                h5param.isShowMenu = true
                NewH5Activity.start(this, h5param)
            }
            R.id.btn_call -> {
                ActionCountUtils.count(ConsultBIConstants.ConsultEvent.APP_CONSULT_LIST_ONLINE_CUSTOMER_CLICK)

                ConsultantIn.startP2PXiaoYi(this)
            }
            R.id.rl_search -> {
                ActionCountUtils.count(
                    YDL_USER_CONSULT_SEARCH_CLICK,
                    tv_search_content.hint.toString()
                )
                ARouter.getInstance()
                    .build("/consult/hot_search")
                    .withString(HOT_SEARCH_DOCTOR_NAME, tv_search_content.text.toString())
                    .navigation()
            }
        }
    }

    private fun scrollToTop() {
        if ((rvExperts.layoutManager as LinearLayoutManager).findFirstVisibleItemPosition() > 10) {
            rvExperts.scrollToPosition(10)
            rvExperts.smoothScrollToPosition(0)
        } else {
            rvExperts.smoothScrollToPosition(0)
        }
    }

    //显示筛选弹窗
    private fun showFilterPopupWindow() {
        tempFilter.categories.clear()
        tempFilter.categories.addAll(allFilter.categories)
        tempFilter.reorder = allFilter.reorder
        tempFilter.region = allFilter.region
        tempFilter.sub = allFilter.sub

        tempFilter.showType = allFilter.showType
        tempFilter.ages.clear()
        tempFilter.ages.addAll(allFilter.ages)
        //排序
        tempFilter.sorStyle.clear()
        tempFilter.sorStyle.addAll(allFilter.sorStyle)
        //学历
        tempFilter.doctorEdu.clear()
        tempFilter.doctorEdu.addAll(allFilter.doctorEdu)
        tempFilter.enquiries.clear()
        tempFilter.enquiries.addAll(allFilter.enquiries)
        // 擅长人群添加数据
        tempFilter.specialityCrowd.clear()
        tempFilter.specialityCrowd.addAll(allFilter.specialityCrowd)
        tempFilter.others.clear()
        tempFilter.others.addAll(allFilter.others)
        tempFilter.priceRanges = allFilter.priceRanges
        tempFilter.priceRangesView = allFilter.priceRangesView

        if (headData?.filters != null) {
            val filterPopupWindow =
                FilterPopupWindow(this, headData?.filters!!, tempFilter, headData?.reorder!!)
            filterPopupWindow.setOnDismissListener {
                viewDim.visibility = View.INVISIBLE
                viewDim_filter.visibility = View.GONE
                if (allFilter.others.size + allFilter.enquiries.size + allFilter.sorStyle.size + allFilter.ages.size + allFilter.doctorEdu.size + allFilter.title.size > 0 || !TextUtils.isEmpty(
                        allFilter.priceRanges?.min_price
                    ) || !TextUtils.isEmpty(allFilter.priceRanges?.max_price)
                ) {
                    updateFilterRightTextViewStatus(tvFilter, FILTER_STATUS_FILTERED)
                } else {
                    updateFilterRightTextViewStatus(tvFilter, FILTER_STATUS_NORMAL)
                }
                ConsultAssistantDialogUtils.INSTANCE.fitRequest(this, "doctor_list", true)
            }
            filterPopupWindow.isClippingEnabled = false
            filterPopupWindow.showAsDropDown(viewSep2)
            ConsultAssistantDialogUtils.INSTANCE.hideAssistantActivity()
            filterPopupWindow.onFilterConfirmListener = this
            updateFilterRightTextViewStatus(tvFilter, FILTER_STATUS_OPEN)
            viewDim.visibility = View.VISIBLE
        } else {
            ToastUtil.toastShort("数据初始化失败，请重试")
            getPresenter().fetchListHead()
        }
    }

    //筛选确认回调
    override fun onFilterConfirmed() {
        updateFilterTextViewStatus(tvFilter, FILTER_STATUS_OPEN)
        LogUtil.d(
            "filter: " + tempFilter.showType.value + ","
                    + tempFilter.enquiries.map { it.value }.joinToString(",") + ","
                    + tempFilter.ages.map { it.value }.joinToString(",") + ","
                    + tempFilter.others.map { it.value }.joinToString(",") + ","
                    + tempFilter.doctorEdu.map { it.value }.joinToString(",")
        )
        props1.put(
            "filtrate_second",
            tempFilter.showType.value + ","
                    + tempFilter.enquiries.map { it.value }.joinToString(",") + ","
                    + tempFilter.ages.map { it.value }.joinToString(",") + ","
                    + tempFilter.others.map { it.value }.joinToString(",") + ","
                    + tempFilter.doctorEdu.map { it.value }.joinToString(",")
        )
        BuryPointUtils.buryPoint("Filtrate", props1)

        // 埋点
        if (tempFilter.specialityCrowd.size > 0) {
            val sign1 = tempFilter.specialityCrowd.joinToString(",") { it.value!! }
            ActionCountUtils.baiDuCountSign3(
                ConsultBIConstants.PART_ID_CONSULT_FILTER_PAGE,
                ConsultBIConstants.ConsultEvent.POSITION_GOODAT_CROWD_CLICK,
                sign1,
                "app",
                ""
            )
        }


        allFilter.showType = tempFilter.showType
        allFilter.enquiries.clear()
        allFilter.enquiries.addAll(tempFilter.enquiries)
        allFilter.ages.clear()
        allFilter.ages.addAll(tempFilter.ages)

        //排序
        allFilter.sorStyle.clear()
        allFilter.sorStyle.addAll(tempFilter.sorStyle)
        //学历
        allFilter.doctorEdu.clear()
        allFilter.doctorEdu.addAll(tempFilter.doctorEdu)
        // 擅长人群
        allFilter.specialityCrowd.clear()
        allFilter.specialityCrowd.addAll(tempFilter.specialityCrowd)
        allFilter.others.clear()
        allFilter.others.addAll(tempFilter.others)
        allFilter.title.clear()
        allFilter.title.addAll(tempFilter.title)
        allFilter.priceRanges = tempFilter.priceRanges
        allFilter.priceRangesView = tempFilter.priceRangesView
        allFilter.reorder = tempFilter.reorder
        //判断主题选中，判断热门筛选中是否也有该主题
        Executors.newCachedThreadPool().execute {
            if (headData!!.highlighter.size > 0) {
                for (index in 0.until(headData!!.highlighter.size)) {
                    if (headData!!.highlighter[index].type == "4") {
                        var textview = lin_filter2.getChildAt(index) as TextView
                        this@ExpertSearchActivity.runOnUiThread {
                            textview.isSelected = false
                            textview.paint.isFakeBoldText = false
                        }
                        for (bean in allFilter.enquiries) {
                            if (TextUtils.equals(
                                    bean.key.toString(),
                                    headData!!.highlighter[index].id
                                )
                            ) {
                                this@ExpertSearchActivity.runOnUiThread {
                                    textview.isSelected = true
                                    textview.paint.isFakeBoldText = true
                                }
                                break
                            }
                        }
                    }
                    if (headData!!.highlighter[index].type == "5") {
                        var textview = lin_filter2.getChildAt(index) as TextView
                        this@ExpertSearchActivity.runOnUiThread {
                            textview.isSelected = false
                            textview.paint.isFakeBoldText = false
                        }
                        for (bean in allFilter.ages) {
                            if (TextUtils.equals(
                                    bean.value.toString(),
                                    headData!!.highlighter[index].id
                                )
                            ) {
                                this@ExpertSearchActivity.runOnUiThread {
                                    textview.isSelected = true
                                    textview.paint.isFakeBoldText = true
                                }
                                break
                            }
                        }
                    }
                    if (headData!!.highlighter[index].type == "6") {
                        var textview = lin_filter2.getChildAt(index) as TextView
                        this@ExpertSearchActivity.runOnUiThread {
                            textview.isSelected = false
                            textview.paint.isFakeBoldText = false
                        }
                        for (bean in allFilter.others) {
                            if (TextUtils.equals(
                                    bean.key.toString(),
                                    headData!!.highlighter[index].id
                                )
                            ) {
                                this@ExpertSearchActivity.runOnUiThread {
                                    textview.isSelected = true
                                    textview.paint.isFakeBoldText = true
                                }
                                break
                            }
                        }
                    }

                    if (headData!!.highlighter[index].type == "7") {
                        var textview = lin_filter2.getChildAt(index) as TextView
                        this@ExpertSearchActivity.runOnUiThread {
                            textview.isSelected = false
                            textview.paint.isFakeBoldText = false
                        }
                        for (bean in allFilter.title) {
                            if (TextUtils.equals(
                                    bean.key.toString(),
                                    headData!!.highlighter[index].id
                                )
                            ) {
                                this@ExpertSearchActivity.runOnUiThread {
                                    textview.isSelected = true
                                    textview.paint.isFakeBoldText = true
                                }
                                break
                            }
                        }
                    }
                }
            }
        }

        filterLabelSet()
        //刷新快捷按钮选中状态
        updateOtherViews(allFilter.others)
        refresh()
    }

    //筛选标题显示处理
    private fun filterLabelSet() {
        if ((allFilter.others.size + allFilter.ages.size + allFilter.doctorEdu.size + allFilter.enquiries.size + allFilter.title.size + allFilter.specialityCrowd.size) == 1) {
            var text: String? = ""
            when {
                allFilter.others.size == 1 -> {
                    text = allFilter.others[0].value
                }
                allFilter.ages.size == 1 -> {
                    text = allFilter.ages[0].value
                }
                allFilter.enquiries.size == 1 -> {
                    text = allFilter.enquiries[0].value
                }
                allFilter.title.size == 1 -> {
                    text = allFilter.title[0].value
                }
                allFilter.specialityCrowd.size == 1 -> {
                    text = allFilter.specialityCrowd[0].value
                }
                allFilter.doctorEdu.size == 1 -> {
                    //学历
                    text = allFilter.doctorEdu[0].value
                }
                else -> {
                    text = "筛选"
                }
            }
            if (text?.length ?: 0 > 4) {
                tvFilter.text = text?.substring(0, 3) + "..."
            } else {
                tvFilter.text = text
            }
        } else {
            tvFilter.text = "筛选"
        }
    }


    private var sortPopup: SortPopupWindow? = null
    private var pricePopup: PricePopupWindow? = null

    //显示价格弹窗
    private fun showPricePopupWindow() {
        pricePopup = headData?.filters?.let { it1 ->
            PricePopupWindow(
                this,
                it1,
                tempFilter, this
            )
        }
        pricePopup?.setOnDismissListener {
            if (tempFilter.priceRanges != null) {
                updateFilterTextViewStatus(tvSort, FILTER_STATUS_FILTERED)
            } else {
                updateFilterTextViewStatus(tvSort, FILTER_STATUS_NORMAL)
            }
        }
        pricePopup!!.showAsDropDown(viewSep2)
    }

    //显示排序弹窗
    private fun showSortPopupWindow() {
        if (headData?.reorder != null) {
            sortPopup = SortPopupWindow(this, headData?.reorder!!, allFilter.reorder, this)
            sortPopup!!.setOnDismissListener {
                viewDim.visibility = View.INVISIBLE
                if (allFilter.reorder != headData!!.reorder[0]) {
                    updateFilterTextViewStatus(tvSort, FILTER_STATUS_FILTERED)
                } else {
                    updateFilterTextViewStatus(tvSort, FILTER_STATUS_NORMAL)
                }
            }
            if (sortPopup!!.selectedSort != allFilter.reorder) {
                sortPopup!!.selectedSort = allFilter.reorder
                sortPopup!!.notifyDataSetChanged()
            }
            sortPopup!!.showAsDropDown(viewSep2)
            updateFilterTextViewStatus(tvSort, FILTER_STATUS_OPEN)
            viewDim.visibility = View.VISIBLE
        } else {
            ToastUtil.toastShort("数据初始化失败，请重试")
            getPresenter().fetchListHead()
        }
    }

    //排序选择回调
    override fun onSortItemSelected(sortItem: ReorderItem) {
        ActionCountUtils.count(
            ConsultBIConstants.ConsultEvent.APP_CONSULT_LIST_SORT_CLICK, sortItem.value
                ?: ""
        )

        when {
            sortItem.value.equals("综合排序") -> {
                tvSort.text = "排序"
            }
            sortItem.value?.length ?: 0 > 4 -> {
                tvSort.text = sortItem.value?.substring(0, 3) + "..."
            }
            else -> {
                tvSort.text = sortItem.value
            }
        }

        //判断排序选中，判断热门筛选中是否也有该排序
        if (headData!!.highlighter.size > 0) {
            for (index in 0.until(headData!!.highlighter.size)) {
                if (headData!!.highlighter[index].type == "3") {
                    var textview = lin_filter2.getChildAt(index) as TextView
                    if (TextUtils.equals(sortItem.value, headData!!.highlighter[index].value)) {
                        textview.isSelected = true
                        textview.paint.isFakeBoldText = true

                        hasSelectedSort = true
                    } else {
                        textview.isSelected = false
                        textview.paint.isFakeBoldText = false
                    }
                }
            }
        }

        updateFilterTextViewStatus(tvSort, FILTER_STATUS_OPEN)
        LogUtil.d("sortItem key: " + sortItem.key + " sortItem value: " + sortItem.value)
        props1.put("filtrate_second", sortItem.value)
        BuryPointUtils.buryPoint("Filtrate", props1)
        allFilter.reorder = sortItem
        sortPopup?.dismiss()
        refresh()
    }

    @SuppressLint("CheckResult")
    fun getRegionByIp(agreeLocation: Boolean) {
        if (agreeLocation) {
            SearchApi.getSearchApi().getCityByIp()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({
                    if (it.code == "200") {
                        locationList?.clear()
                        subLocationItem?.code = it.data.city_code
                        subLocationItem?.key = it.data.city_code
                        subLocationItem?.value = it.data.city_name
                        subLocationItem?.locationCode = "-1"
                        subLocationItem?.let { locationList?.add(it) }
                        locationRegionItem = locationList?.let { it1 ->
                            RegionItem(
                                it1,
                                value = "定位",
                                key = it.data.province_code,
                                code = it.data.province_code
                            )
                        }
                        locationRegionItem?.let { locationHistoryList?.add(0, it) }
                        showAreaPoPup(agreeLocation)
                    } else {
                        locationList?.clear()
                        subLocationItem?.code = null
                        subLocationItem?.key = null
                        subLocationItem?.value = "定位失败，请稍后再试"
                        subLocationItem?.locationCode = "NotAuth"
                        subLocationItem?.let { locationList?.add(it) }
                        locationRegionItem = locationList?.let { it1 ->
                            RegionItem(
                                it1,
                                value = "定位",
                                key = null,
                                code = null
                            )
                        }
                        locationRegionItem?.let { locationHistoryList?.add(0, it) }
                        showAreaPoPup(agreeLocation)
                    }
                }, {
                    ErrorLocate(false)
                })
        } else {
            ErrorLocate(agreeLocation)
        }
    }

    private fun ErrorLocate(agreeLocation: Boolean) {
        locationList?.clear()
        subLocationItem?.code = null
        subLocationItem?.key = null
        subLocationItem?.value = "开启授权，获得定位城市"
        subLocationItem?.locationCode = "NotAuth"
        subLocationItem?.let { locationList?.add(it) }
        locationRegionItem = locationList?.let { it1 ->
            RegionItem(
                it1,
                value = "定位",
                key = null,
                code = null
            )
        }
        locationRegionItem?.let { locationHistoryList?.add(0, it) }
        showAreaPoPup(agreeLocation)
    }

    private fun showAreaPoPup(isAgreeLocation: Boolean) {
        locationHistoryList?.addAll(headData?.region ?: ArrayList())
        if (allFilter.region.value == null) allFilter.region = locationRegionItem!!
        val regionPopupWindow = locationHistoryList?.let {
            AreaPopupWindow(
                this,
                it,
                allFilter.region,
                allFilter.sub,
                isAgreeLocation
            )
        }
        regionPopupWindow?.showAsDropDown(viewSep2)
        viewDim.visibility = View.VISIBLE
        updateFilterTextViewStatus(tvArea, FILTER_STATUS_OPEN)
        regionPopupWindow?.setOnDismissListener {
            viewDim.visibility = View.INVISIBLE
            if (tvArea.text != "城市") {
                updateFilterTextViewStatus(tvArea, FILTER_STATUS_FILTERED)
            } else {
                updateFilterTextViewStatus(tvArea, FILTER_STATUS_NORMAL)
            }
        }
        regionPopupWindow?.onRegionSelectedListener =
            object : AreaPopupWindow.OnRegionSelectedListener {
                override fun onRegionSelected(region: RegionItem, sub: SubItem) {
                    updateFilterTextViewStatus(tvArea, FILTER_STATUS_OPEN)
                    allFilter.region = region
                    allFilter.sub = sub
                    if (TextUtils.isEmpty(region.code) && TextUtils.isEmpty(sub.code)) {
                        tvArea.text = "城市"
                    } else if (!TextUtils.isEmpty(region.code) && !TextUtils.isEmpty(sub.code)) {
                        if (region.value?.length ?: 0 > 4) {
                            tvArea.text = region.value?.substring(0, 3) + "..."
                        } else {
                            tvArea.text = region.value
                        }
                    } else {
                        if (sub.value?.length ?: 0 > 4) {
                            tvArea.text = sub.value?.substring(0, 3) + "..."
                        } else {
                            tvArea.text = sub.value
                        }
                    }
                    ActionCountUtils.count(
                        ConsultBIConstants.ConsultEvent.APP_CONSULT_LIST_AREA_CLICK,
                        region.value + "|" + sub.value
                    )

                    //更新热门搜索显示状态
                    if (headData!!.highlighter.size > 0) {
                        for ((index, hot) in headData!!.highlighter.withIndex()) {
                            if (hot.type == "2" || hot.type == "8") {
                                val textview = lin_filter2.getChildAt(index) as TextView
                                //有选择城市
                                if (!TextUtils.isEmpty(sub.code)) {
                                    if (TextUtils.equals(sub.code, hot.id)) {
                                        textview.isSelected = true
                                        textview.paint.isFakeBoldText = true
                                        hasSelectedArea = true
                                    } else {
                                        textview.isSelected = false
                                        textview.paint.isFakeBoldText = false
                                    }
                                } else {
                                    if (TextUtils.equals(region.code, hot.id)) {
                                        textview.isSelected = true
                                        textview.paint.isFakeBoldText = true
                                        hasSelectedArea = true
                                    } else {
                                        textview.isSelected = false
                                        textview.paint.isFakeBoldText = false
                                    }
                                }
                            }
                        }
                    }
                    regionPopupWindow?.dismiss()
                    refresh()
                }
            }
    }

    //显示地区弹窗
    private fun showAreaPopupWindow(isAgreeLocation: Boolean) {
        if (headData?.region != null) {
            locationHistoryList?.clear()
            //添加历史搜索
            var recentCityBean =
                MMKV.defaultMMKV().decodeParcelable(
                    ConsultBIConstants.ConsultantLocationAuth.RECENT_CITY,
                    ConsultantRecentCity::class.java
                )
            if (recentCityBean == null) recentCityBean = ConsultantRecentCity(arrayListOf())
            locationHistoryList?.add(
                RegionItem(
                    recentCityBean!!.recentCity,
                    value = "历史",
                    key = "0",
                    code = "0"
                )
            )
            //添加定位
            getRegionByIp(isAgreeLocation)
        } else {
            ToastUtil.toastShort("数据初始化失败，请重试")
            getPresenter().fetchListHead()
        }
    }

    private var mHandler: Handler? = null

    /**
     * 显示主题弹窗
     */
    private fun showSubjectPopupWindow() {
        val categoryPopup = CategoryPopupWindow(this, allFilter)
        mHandler = Handler()
        mHandler!!.post {
            categoryPopup.updateData()
        }
        categoryPopup.setOnDismissListener {
            viewDim.visibility = View.INVISIBLE
            ConsultAssistantDialogUtils.INSTANCE.fitRequest(this, "doctor_list", true)
        }
        ConsultAssistantDialogUtils.INSTANCE.hideAssistantActivity()
        categoryPopup.onSubjectsSelectedListener = this
        categoryPopup.showAsDropDown(viewSep2)
        updateFilterTextViewStatus(tvSubject, FILTER_STATUS_OPEN)
        viewDim.visibility = View.VISIBLE
    }

    /**
     *   显示八大类弹窗
     */
    private fun showeightCategoryPopupWindow() {
        eightcategoryPopup = EightCategoryPopupWindow(this, allFilter)
        eightcategoryPopup?.setListener(this)
        eightcategoryPopup?.setOnDismissListener {
            viewDim.visibility = View.INVISIBLE
            ConsultAssistantDialogUtils.INSTANCE.fitRequest(this, "doctor_list", true)
        }
        ConsultAssistantDialogUtils.INSTANCE.hideAssistantActivity()
        eightcategoryPopup?.showAsDropDown(viewSep2)
        updateFilterTextViewStatus(tvSubject, FILTER_STATUS_OPEN)
        viewDim.visibility = View.VISIBLE
    }

    /**
     * 主题选择确认回调
     *
     * 新增逻辑：当主题选择后，需要判断热门筛选中是否也有该主题，如果有，也需要同步更新选中状态
     */
    override fun onCategoriesSelected(signLit: ArrayList<String>) {
        eightcategoryPopup?.dismiss()
        if (signLit.isNotEmpty()) {
            val sign1 = signLit.joinToString(",") { it }
            ActionCountUtils.baiDuCountSign3(
                ConsultBIConstants.PART_ID_CONSULT_COUNSELOR_LIST_PAGE,
                ConsultBIConstants.ConsultEvent.POSITION_TWO_CATEGORY_CLICK,
                sign1,
                "app",
                ""
            )
        }

        if (allFilter.categoryId2List.size > 0 || allFilter.categoryId3List.size > 0) {
            updateFilterTextViewStatus(tvSubject, FILTER_STATUS_FILTERED)
        } else {
            updateFilterTextViewStatus(tvSubject, FILTER_STATUS_NORMAL)
        }
        refresh()
    }

    override fun onRefresh() {
        refresh(false)
        recommendListView.requestData(initCategory)
    }

    //刷新列表
    private fun refresh(isShowRefresh: Boolean? = true) {
        srlContainer.isRefreshing = isShowRefresh!!
        onScrollListener.resetState()
        getPresenter().mExtras = null
        getPresenter().fetchListData(allFilter, getPresenter().mExtras, mapFilter)
        rvExperts.scrollToPosition(0)
    }

    //重置所有筛选
    private fun resetFilter() {
        allFilter.categories.clear()
        allFilter.categories.add(headData?.cates?.get(0) ?: CateItem())
        allFilter.reorder = headData?.reorder?.get(0) ?: ReorderItem()
        allFilter.region = RegionItem()
        allFilter.sub = SubItem()
        allFilter.enquiries.clear()
        allFilter.ages.clear()
        allFilter.sorStyle.clear()
        allFilter.doctorEdu.clear()
        allFilter.others.clear()
        updateFilterTextViewStatus(tvSubject, FILTER_STATUS_NORMAL)
        updateFilterTextViewStatus(tvArea, FILTER_STATUS_NORMAL)
        updateFilterTextViewStatus(tvSort, FILTER_STATUS_NORMAL)

        if (headData != null) {
            if (allFilter.showType != headData!!.filters.showType[1]) {
                updateFilterTextViewStatus(tvFilter, FILTER_STATUS_FILTERED)
            } else {
                updateFilterTextViewStatus(tvFilter, FILTER_STATUS_NORMAL)
            }
        }
    }

    private fun updateFilterTextViewStatus(tv: TextView, status: Int) {
        when (status) {
            FILTER_STATUS_NORMAL -> {
                tv.typeface = Typeface.defaultFromStyle(Typeface.NORMAL)
                tv.setTextColor(ContextCompat.getColor(mContext, R.color.platform_colorTextDefault))
                tv.setCompoundDrawablesWithIntrinsicBounds(
                    0,
                    0,
                    R.drawable.platform_ic_arrow_drop_down_grey_500_18dp,
                    0
                )
            }
            FILTER_STATUS_FILTERED -> {
                tv.typeface = Typeface.DEFAULT_BOLD
                tv.setTextColor(ContextCompat.getColor(mContext, R.color.platform_main_theme))
                tv.setCompoundDrawablesWithIntrinsicBounds(
                    0,
                    0,
                    R.drawable.platform_arrow_drop_down_en,
                    0
                )
            }
            FILTER_STATUS_OPEN -> {
                tv.typeface = Typeface.DEFAULT_BOLD
                tv.setTextColor(ContextCompat.getColor(mContext, R.color.platform_main_theme))
                tv.setCompoundDrawablesWithIntrinsicBounds(
                    0,
                    0,
                    R.drawable.platform_arrow_drop_down_en,
                    0
                )
            }
        }
    }

    //设置筛选点击按钮状态
    private fun updateFilterRightTextViewStatus(tv: TextView, status: Int) {
        when (status) {
            FILTER_STATUS_NORMAL -> {
                tv.typeface = Typeface.defaultFromStyle(Typeface.NORMAL)
                tv.setTextColor(ContextCompat.getColor(this, R.color.platform_colorTextDefault))
                tv.setCompoundDrawablesWithIntrinsicBounds(
                    0,
                    0,
                    R.drawable.filter_up_grey,
                    0
                )
            }
            FILTER_STATUS_FILTERED -> {
                tv.typeface = Typeface.DEFAULT_BOLD
                tv.setTextColor(ContextCompat.getColor(this, R.color.platform_main_theme))
                tv.setCompoundDrawablesWithIntrinsicBounds(
                    0,
                    0,
                    R.drawable.filter_down_blue,
                    0
                )
            }
            FILTER_STATUS_OPEN -> {
                tv.typeface = Typeface.DEFAULT_BOLD
                tv.setTextColor(ContextCompat.getColor(this, R.color.platform_main_theme))
                tv.setCompoundDrawablesWithIntrinsicBounds(
                    0,
                    0,
                    R.drawable.filter_down_blue,
                    0
                )
            }
        }
    }

    private fun hideSoftInput() {
        val view = this.currentFocus
        if (view != null) {
            val imm = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
            imm.hideSoftInputFromWindow(view.windowToken, 0)
        }
    }


    override fun onResume() {
        super.onResume()
        ActionCountUtils.count(ConsultBIConstants.ConsultSearchListEvent.APP_CONSULT_SEARCH_LIST_PAGE_VISIT)

    }

    override fun onDestroy() {
        super.onDestroy()
        mHandler = null
        bottomWordDisposable?.dispose()
        ConsultAssistantDialogUtils.INSTANCE.expertSearchResetStatus()
    }

    override fun onPriceItemSelected(priceRangesItem: PriceRangesItem) {
        //价格筛选回调
        updateFilterTextViewStatus(tvSort, FILTER_STATUS_FILTERED)
        allFilter.priceRanges = priceRangesItem
        refresh(false)
    }
}
