package com.yidianling.consultant.adapter

import android.annotation.SuppressLint
import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.ChildrenBean
import com.yidianling.consultant.model.bean.EightCategoryBean
import kotlinx.android.synthetic.main.consultant_layout_category_view.*
import kotlinx.android.synthetic.main.eight_category_detail_list_item.view.*
import kotlinx.android.synthetic.main.eight_category_list_item.view.*

/**
 * Created by zqk on 17-9-20.
 */
class CategoryDetailAdapter(
    private val context: Context,
    private val categoryDetailList: MutableList<MutableList<ChildrenBean>>,
    private val categoryNamelList: MutableList<EightCategoryBean>,
) : RecyclerView.Adapter<CategoryDetailAdapter.ViewHolder>() {
    lateinit var outAdapterClicklistener: OutAdapterClicklistener
    override fun getItemCount(): Int = categoryNamelList.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val itemView =
            LayoutInflater.from(context)
                .inflate(R.layout.eight_category_detail_list_item, parent, false)
        return ViewHolder(itemView)
    }

    override fun onBindViewHolder(holder: ViewHolder, @SuppressLint("RecyclerView") position: Int) {

        holder.category_name.text = categoryNamelList[position].string

        val eightCategoryAdapter = CategoryDetailTextAdapter(context, categoryDetailList[position])
        eightCategoryAdapter.setOnClick(object :
            CategoryDetailTextAdapter.TextAdapterOnclickListener {
            override fun textOnClick(textPosition: Int) {
                outAdapterClicklistener.outAdapterClick(position, textPosition)
            }
        })
        if (categoryDetailList[position].size > 9) {
            holder.collapse_hide.visibility = View.VISIBLE
            holder.arrow_collapse_hide.visibility = View.VISIBLE
        } else {
            holder.collapse_hide.visibility = View.GONE
            holder.arrow_collapse_hide.visibility = View.GONE
        }
        if (categoryNamelList[position].collapse) {
            eightCategoryAdapter.setAllVisible()
            holder.collapse_hide.text = "收起"
            holder.arrow_collapse_hide.background =
                context.resources.getDrawable(R.drawable.consult_hide_arrow)
        } else {
            eightCategoryAdapter.setGone()
            holder.collapse_hide.text = "展开"
            holder.arrow_collapse_hide.background =
                context.resources.getDrawable(R.drawable.consult_collapse_arrow)
        }
        holder.collapse_hide.setOnClickListener {
            if (categoryNamelList[position].collapse) {
                //显示 展开
                categoryNamelList[position].collapse = false
                holder.collapse_hide.text = "展开"
                holder.arrow_collapse_hide.background =
                    context.resources.getDrawable(R.drawable.consult_collapse_arrow)
                eightCategoryAdapter.setGone()
            } else {
                //显示收起
                categoryNamelList[position].collapse = true
                holder.collapse_hide.text = "收起"
                holder.arrow_collapse_hide.background =
                    context.resources.getDrawable(R.drawable.consult_hide_arrow)
                eightCategoryAdapter.setAllVisible()
            }
        }
        holder.category_list_detail.layoutManager = GridLayoutManager(context, 3)
        holder.category_list_detail.adapter = eightCategoryAdapter

    }

    interface OutAdapterClicklistener {
        fun outAdapterClick(outPosition: Int, inPosition: Int)
    }

    fun setOutClicklistener(listener: OutAdapterClicklistener) {
        this.outAdapterClicklistener = listener
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val category_name = itemView.category_name
        val category_list_detail = itemView.category_list_detail
        val collapse_hide = itemView.collapse_hide
        val arrow_collapse_hide = itemView.arrow_collapse_hide

    }
}