package com.yidianling.consultant.adapter

import android.annotation.SuppressLint
import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.ChildrenBean
import kotlinx.android.synthetic.main.consultant_layout_category_view.*
import kotlinx.android.synthetic.main.eight_category_detail_item_item.view.*
import kotlinx.android.synthetic.main.eight_category_detail_list_item.view.*
import kotlinx.android.synthetic.main.eight_category_list_item.view.*

/**
 * Created by zqk on 17-9-20.
 */
class CategoryDetailTextAdapter(
    private val context: Context,
    private val categoryDetailList: MutableList<ChildrenBean>,
) : RecyclerView.Adapter<CategoryDetailTextAdapter.ViewHolder>() {
    var isVisible = false
    lateinit var textAdapterOnclickListener: TextAdapterOnclickListener
    override fun getItemCount(): Int = categoryDetailList.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val itemView =
            LayoutInflater.from(context)
                .inflate(R.layout.eight_category_detail_item_item, parent, false)

        return ViewHolder(itemView)
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        var param = RecyclerView.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        );

        if (categoryDetailList[position].isVisible) {
            param.height = ViewGroup.LayoutParams.WRAP_CONTENT
            param.width = ViewGroup.LayoutParams.MATCH_PARENT
            param.setMargins(0, 0, 10, 10)
            holder.itemView.visibility = View.VISIBLE
        } else {
            param.height = 0
            param.width = 0
            holder.itemView.visibility = View.GONE;
        }
        holder.itemView.layoutParams = param

        holder.category_name_detail.text = categoryDetailList[position].cate_name
        holder.category_name_detail.isSelected = categoryDetailList[position].isSelected
        if (categoryDetailList[position].isSelected) {
            holder.category_name_detail.setTextColor(context.resources.getColor(R.color.platform_main_theme))
            holder.category_name_detail.background =
                context.getDrawable(R.drawable.consult_price_expert_selected)
        } else {
            holder.category_name_detail.background =
                context.getDrawable(R.drawable.consult_price_expert_unseleted)
            holder.category_name_detail.setTextColor(context.resources.getColor(R.color.platform_color_333333))
        }
        holder.itemView.setOnClickListener {
            textAdapterOnclickListener.textOnClick(position)
        }

    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val category_name_detail = itemView.category_name_detail

    }

    interface TextAdapterOnclickListener {
        fun textOnClick(position: Int)
    }

    fun setOnClick(adapterOnclickListener: TextAdapterOnclickListener) {
        this.textAdapterOnclickListener = adapterOnclickListener
    }

    fun setAllVisible() {
        categoryDetailList.forEach { bean ->
            bean.isVisible = true
        }
        notifyDataSetChanged()
        isVisible = true
    }

    fun setGone() {
        categoryDetailList.forEachIndexed { index, bean ->
            if (index > 8) {
                bean.isVisible = false
            }
        }
        notifyDataSetChanged()
        isVisible = false
    }
}