package com.yidianling.consultant.adapter

import android.text.SpannableString
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.widget.TextView
import androidx.core.content.ContextCompat
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.yidianling.consultant.R
import com.yidianling.consultant.bean.SearchSuggestListBean


/**
 * Created by Ykai on 2022/5/30.
 */
class SearchWordsAdapter(data: List<SearchSuggestListBean>) : BaseQuickAdapter<SearchSuggestListBean, BaseViewHolder>(R.layout.consultant_item_search_words,data) {
    private var mSearchWord:String = ""

    override fun convert(holder: BaseViewHolder, item: SearchSuggestListBean) {
        val tvSearchWords = holder.getView<TextView>(R.id.tv_search_words)
        tvSearchWords.text = setWordsStyle(item.suggest_content,mSearchWord)
    }


    fun notifyDataAndSetSearchWord(searchWord: String){
        mSearchWord = searchWord
        notifyDataSetChanged()
    }

    private fun setWordsStyle(words:String,searchWord:String):SpannableString{
        val spannableString = SpannableString(words)
        if (words.contains(searchWord)){
            val startIndex = words.indexOf(searchWord)
            val endIndex = startIndex+searchWord.length
            spannableString.setSpan(ForegroundColorSpan(ContextCompat.getColor(mContext,R.color.platform_main_theme)), startIndex, endIndex, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
        }
        return spannableString
    }
}