package com.yidianling.consultant.adapter

import android.widget.TextView
import androidx.core.content.ContextCompat
import com.chad.library.adapter.base.BaseMultiItemQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.ChildrenBean

/**
 * Created by Ykai on 2022/5/18.
 */
class SortAdapter(data: List<ChildrenBean>) :
    BaseMultiItemQuickAdapter<ChildrenBean, BaseViewHolder>(data) {
    var isVisible = false

    init {
        addItemType(1, R.layout.consultant_item_sort1)
        addItemType(2, R.layout.consultant_item_sort2)
    }

    override fun convert(holder: BaseViewHolder, item: ChildrenBean) {
        when (holder.itemViewType) {
            1 -> {
                holder.setGone(R.id.ll_sort_item, item.isVisible)
                holder.setText(R.id.tv_sort_name, item.cate_name)
                holder.getView<TextView>(R.id.tv_sort_name).isSelected = item.isSelected
                if (item.isSelected) {
                    holder.setTextColor(
                        R.id.tv_sort_name,
                        ContextCompat.getColor(mContext, R.color.platform_main_theme)
                    )
                } else {
                    holder.setTextColor(
                        R.id.tv_sort_name,
                        ContextCompat.getColor(mContext, R.color.platform_color_242424)
                    )
                }
            }
            2 -> {
                holder.setGone(R.id.ll_sort_item, item.isVisible)
                holder.setText(R.id.tv_sort_name, item.cate_name)
                holder.getView<TextView>(R.id.tv_sort_name).isSelected = item.isSelected
                if (item.isSelected) {
                    holder.setTextColor(
                        R.id.tv_sort_name,
                        ContextCompat.getColor(mContext, R.color.platform_main_theme)
                    )
                } else {
                    holder.setTextColor(
                        R.id.tv_sort_name,
                        ContextCompat.getColor(mContext, R.color.platform_color_242424)
                    )
                }
            }
        }
    }


    /**
     * 设置大于第12个之后的标签全部显示
     */
    fun setAllVisible() {
        mData.forEach { bean ->
            bean.isVisible = true
        }
        notifyDataSetChanged()
        isVisible = true
    }

    /**
     * 设置大于第12个之后的标签全部隐藏
     */
    fun setGone() {
        mData.forEachIndexed { index, bean ->
            if (index > 12) {
                bean.isVisible = false
            }
        }
        notifyDataSetChanged()
        isVisible = false
    }
}