package com.yidianling.consultant.adapter

import android.content.Context
import android.graphics.Typeface
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.ydl.ydlcommon.adapter.MyBaseAdapter
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.SubItem
import kotlinx.android.synthetic.main.consultant_item_consult_type.view.*

/**
 * 城市列表适配器
 * Created by zqk on 17-7-21.
 */
class SubRecyclerViewAdapter(
    val context: Context, val subList: ArrayList<SubItem>,
    var selectedSub: SubItem, val locationCode: String
) : RecyclerView.Adapter<SubRecyclerViewAdapter.ViewHolder>() {

    var onItemClickListener: MyBaseAdapter.OnItemClickListener<SubItem>? = null
    private lateinit var mOnAuthClickLister: OnAuthClickLister
    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val subItem = subList[position]
        holder.itemView.tvConsultTypeName.text = subItem.value
        if (subItem.locationCode == locationCode) {
            holder.itemView.reLocation.visibility = View.GONE
            holder.itemView.location_img.visibility = View.VISIBLE
            holder.itemView.location_img.drawable.setTint(context.resources.getColor(R.color.platform_color_black_333333))

            holder.itemView.isEnabled = true
        } else if (subItem.locationCode == "NotAuth") {
            //未选中状态
            holder.itemView.reLocation.visibility = View.VISIBLE
            holder.itemView.reLocation.setOnClickListener {
                mOnAuthClickLister.onAuthClick()
            }
            holder.itemView.location_img.visibility = View.VISIBLE
            holder.itemView.tvConsultTypeName.setTypeface(Typeface.DEFAULT)
            holder.itemView.tvConsultTypeName.setTextColor(
                ContextCompat.getColor(
                    context,
                    R.color.platform_default_text_color
                )
            )
            holder.itemView.location_img.drawable.setTint(context.resources.getColor(R.color.platform_color_black_333333))
            holder.itemView.isEnabled = false
        } else {
            holder.itemView.reLocation.visibility = View.GONE
            holder.itemView.isEnabled = true
            holder.itemView.location_img.visibility = View.GONE
            if (selectedSub.code == subItem.code) {
                //选中状态
                holder.itemView.tvConsultTypeName.setTypeface(Typeface.DEFAULT_BOLD)
                holder.itemView.tvConsultTypeName.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.platform_main_theme
                    )
                )
            } else {
                //未选中状态
                holder.itemView.tvConsultTypeName.setTypeface(Typeface.DEFAULT)
                holder.itemView.tvConsultTypeName.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.platform_default_text_color
                    )
                )
            }
        }

    }

    override fun getItemCount(): Int = subList.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(context)
            .inflate(R.layout.consultant_item_consult_type, parent, false)
        return ViewHolder(view)
    }

    interface OnAuthClickLister {
        fun onAuthClick()
    }

    fun setOnAuthClickLister(lister: OnAuthClickLister) {
        mOnAuthClickLister = lister
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        init {
            itemView.setOnClickListener {
                val position = adapterPosition
                if (position != RecyclerView.NO_POSITION) {
                    selectedSub = subList[adapterPosition]
                    onItemClickListener?.onItemClickListener(itemView, adapterPosition, selectedSub)
                    notifyDataSetChanged()
                }
            }
        }
    }
}