package com.yidianling.consultant.contract

import android.content.Context
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.consultant.bean.HotSearchBean
import com.yidianling.consultant.bean.SearchWordsBean
import com.yidianling.consultant.model.bean.FunctionWordBean
import io.reactivex.Observable

/**
 * @author yuanWai
 * @描述: 搜索页面约束类
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/03/19
 */
class IHotSearchContract {

    interface View : IView {
        /**
         * 搜索页接口
         */
        fun searchDataResponse(hotSearchBean: HotSearchBean)

        /**
         * 搜索页请求热门词
         */
        fun searchHotWordData(wordList: MutableList<FunctionWordBean>)

        /**
         * 请求失败
         */
        fun requestFail()

        /**
         * 联想词请求成功结果
         */
        fun getSearchWordsSuccess(
            searchWordsBean: SearchWordsBean,
            searchContent: String,
            isClickWords: Boolean
        )
    }

    interface Presenter : IPresenter<View> {
        /**
         * 获取本地缓存
         */
        fun localData(context: Context)

        /**
         * 搜索页接口请求
         */
        fun searchData()

        /**
         * 搜索页请求热门词
         */
        fun searchHotWordData(map: HashMap<String, Any>)

        /**
         * 获取联想词
         */
        fun getSearchWords(map: HashMap<String, Any>, searchContent: String, isClickWords: Boolean)
    }

    interface Model : IModel {
        /**
         * 搜索页接口
         */
        fun searchData(): Observable<HotSearchBean>

        /**
         * 获取到联想词
         */
        fun getSearchWords(map: HashMap<String, Any>): Observable<SearchWordsBean>

        /**
         * 搜索页请求热门词
         */
        fun searchHotWordData(map: HashMap<String, Any>): Observable<BaseAPIResponse<MutableList<FunctionWordBean>>>
    }
}