package com.yidianling.consultant.dialog


import android.animation.Animator
import android.animation.ObjectAnimator
import android.app.Dialog
import android.content.Context
import android.net.Uri
import android.os.Bundle
import android.os.Handler
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import com.facebook.drawee.backends.pipeline.Fresco
import com.facebook.drawee.interfaces.DraweeController
import com.yidianling.common.tools.RxImageTool
import com.yidianling.consultant.R
import com.yidianling.consultant.modular.singlton.ConsultAssistantDialogUtils
import kotlinx.android.synthetic.main.consultant_expert_consult_assistant_popup_window.*


/**
 * 咨询助理浮层
 * Created by xj on 2019/10/30.
 */

class ConsultAssistantDialog(
    mContext: Context,
    val consultAssistantClickListener: OnConsultAssistantClickListener?
) : Dialog(mContext, R.style.consultant_expert_dialog_default_style) {
    private var animate: ObjectAnimator? = null
    private var minWidth: Int? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.consultant_expert_consult_assistant_popup_window)

        val params = window?.attributes
        params?.width = WindowManager.LayoutParams.WRAP_CONTENT
        params?.height = WindowManager.LayoutParams.WRAP_CONTENT
        params?.gravity = Gravity.RIGHT + Gravity.BOTTOM
        params?.verticalMargin = 0.07f
        params?.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE //不拦截外部点击事件
        window?.attributes = params
        window?.setDimAmount(0f)

        window?.setWindowAnimations(R.style.consultant_expert_consult_assistant_dialog_animate)

        if (!ConsultAssistantDialogUtils.INSTANCE.canShowDesc()) {
            consultant_assistant_dialog_desc_ll.visibility = View.GONE
            consultant_assistant_dialog_desc_outside_ll.visibility = View.GONE
            refreshDialogLayout(ConsultAssistantDialogUtils.INSTANCE.minWidth)
        }

        consultant_assistant_dialog_close.setOnClickListener {
            if (minWidth == null) {
                minWidth = (consultant_assistant.measuredWidth * 1.5).toInt()
            }
            ConsultAssistantDialogUtils.INSTANCE.minWidth = minWidth!!

            //一个dialog关闭左侧desc，所有导医左侧desc都关闭
//            SharedPreferencesEditor.putString(
//                ConsultAssistantDialogUtils.INSTANCE.ASSISTANT_DIALOG_SP_TAG,
//                System.currentTimeMillis().toString()
//            )
            ConsultAssistantDialogUtils.isSHowDesc = false
            animate = ObjectAnimator.ofFloat(
                consultant_assistant_dialog_desc_ll,
                "translationX",
                0.0f,
                consultant_assistant_dialog_desc_ll.measuredWidth.toFloat()
            )

            animate?.setDuration(900)?.start()
            animate?.addListener(object : Animator.AnimatorListener {
                override fun onAnimationRepeat(animation: Animator?) {

                }

                override fun onAnimationEnd(animation: Animator?) {
                    if (ownerActivity != null) {
                        ConsultAssistantDialogUtils.INSTANCE.setDescHide()
                        hide()
                        Handler().postDelayed({
                            show()
                        }, 10)
                    }

                }

                override fun onAnimationCancel(animation: Animator?) {
                }

                override fun onAnimationStart(animation: Animator?) {
                }
            })
        }


        val controller: DraweeController = Fresco.newDraweeControllerBuilder()
            .setUri(Uri.parse("res://drawable/"+R.drawable.consultant_assistant_dialog_img))
            .setOldController(consultant_assistant.controller)
            .setAutoPlayAnimations(true) // 是否自动播放Gif动画
            .build()
        consultant_assistant.controller = controller



        consultant_assistant.setOnClickListener {
            consultAssistantClickListener?.onClickAction()
        }
        ll_desc_assistant.setOnClickListener {
            consultAssistantClickListener?.onClickAction()
        }

        setCanceledOnTouchOutside(false)
    }

    public fun setDescHide() {
        if (null != consultant_assistant_dialog_desc_ll) {
            consultant_assistant_dialog_desc_ll.visibility = View.GONE
            consultant_assistant_dialog_desc_outside_ll.visibility = View.GONE
            refreshDialogLayout(ConsultAssistantDialogUtils.INSTANCE.minWidth)
        }
    }

    // 刷新dialog布局，减小拦截点击区域
    fun refreshDialogLayout(width: Int) {
        val params = window?.attributes

        minWidth = if (width != 0) {
            width
        } else {
            (RxImageTool.dp2px(60f) * 1.5).toInt()
        }

        params?.width = minWidth
        params?.height = WindowManager.LayoutParams.WRAP_CONTENT
        params?.gravity = Gravity.RIGHT + Gravity.BOTTOM
        params?.verticalMargin = 0.07f
        params?.horizontalMargin = 0.01f
        window?.setWindowAnimations(0)
        window?.attributes = params
    }

    interface OnConsultAssistantClickListener {
        fun onClickAction()
    }
}