package com.yidianling.consultant.dialog

import `in`.xiandan.countdowntimer.CountDownTimerSupport
import `in`.xiandan.countdowntimer.OnCountDownTimerListener
import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.utils.SharedPreferencesEditor
import com.yidianling.common.tools.ToastUtil
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.PromptPaymentBean
import java.text.DecimalFormat
import java.text.SimpleDateFormat
import java.util.*


/**
 * 咨询助理浮层
 * Created by xj on 2019/10/30.
 */

class ConsultSubPayDialog(
    private val mContext: Context,
    private val promptPaymentBean: PromptPaymentBean
) : Dialog(mContext, R.style.dialog_default_style) {

    var mTimer: CountDownTimerSupport? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.consultant_expert_consult_sub_pay_dialog)
        val params = window.attributes
        params.width = WindowManager.LayoutParams.WRAP_CONTENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        params.gravity = Gravity.CENTER
        window.attributes = params
        setCanceledOnTouchOutside(false)
        initView();
    }

    private fun initView() {
        var titleTv = findViewById<TextView>(R.id.tv_title)
        var timeTv = findViewById<TextView>(R.id.tv_time)
        titleTv.paint.isFakeBoldText = true
        Glide.with(mContext)
            .load(promptPaymentBean.smallImage).into(findViewById<ImageView>(R.id.avaterIv))
        findViewById<TextView>(R.id.nameTv).text = promptPaymentBean.name
        findViewById<TextView>(R.id.desTv).text = promptPaymentBean.productName
        val decimalFormat = DecimalFormat("###.##")
        val price = decimalFormat.format(promptPaymentBean.price)
        findViewById<TextView>(R.id.priceTv).text = "¥$price"
        var format = SimpleDateFormat("HH:mm:ss");
        format.timeZone = TimeZone.getTimeZone("GMT+0");
        var millisInFuture =
            promptPaymentBean.toPayTime?.minus(promptPaymentBean.currentTime ?: 0) ?: 0
        mTimer = CountDownTimerSupport(millisInFuture, 1000)
        mTimer?.setOnCountDownTimerListener(object : OnCountDownTimerListener {
            override fun onTick(millisUntilFinished: Long) {
                val time = format.format(millisUntilFinished)
                timeTv.text = time
            }

            override fun onFinish() {
                var nextShowTime =
                    System.currentTimeMillis() + ((promptPaymentBean.orderToPayTime ?: 1) * 1000)
                SharedPreferencesEditor.putString("orderToPayTime", nextShowTime.toString())
                dismiss()
            }

            override fun onCancel() {
                // 倒计时手动停止
            }
        })
        mTimer?.start()
        findViewById<TextView>(R.id.tv_close).setOnClickListener {
            var nextShowTime =
                System.currentTimeMillis() + ((promptPaymentBean.orderToPayTime ?: 1) * 1000)
            SharedPreferencesEditor.putString("orderToPayTime", nextShowTime.toString())
            mTimer?.stop()
            dismiss()

        }

        findViewById<View>(R.id.pay).setOnClickListener {
            if (!TextUtils.isEmpty(promptPaymentBean.orderDetailUrl)) {
                val h5Params = H5Params(promptPaymentBean.orderDetailUrl!!, null)
                NewH5Activity.start(context, h5Params)
                dismiss()
            } else {
                ToastUtil.toastShort("跳转失败")
                dismiss()
            }
            var nextShowTime =
                System.currentTimeMillis() + ((promptPaymentBean.orderToPayTime ?: 1) * 1000)
            SharedPreferencesEditor.putString("orderToPayTime", nextShowTime.toString())
        }
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        if (mTimer != null) {
            mTimer?.stop()
            mTimer = null
        }
    }

}