package com.yidianling.consultant.http

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.yidianling.consultant.bean.ExpertSearchTopShowBean
import com.yidianling.consultant.bean.SearchWordsBean
import com.yidianling.consultant.model.bean.ExpertBean
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:专家搜索页请求接口
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/11
 */
interface IExpertSearchHttp{
    /**
     * 专家搜索页请求
     */
//    fun searchDoctor(params : String?): Observable<BaseAPIResponse<ExpertSearchBean>>

    /**
     * 获取搜索联想词
     */
//    fun getSearchWords(map:Map<String,Any>): Observable<BaseAPIResponse<SearchWordsBean>>

    /**
     * 获取专家列表
     */
    fun getExpertList(map:Map<String,Any>): Observable<BaseAPIResponse<ExpertBean>>

    /**
     * 获取当前筛选条件结果数
     */
    fun getFilterCount(params:String?): Observable<BaseAPIResponse<Int>>

    /**
     * 获取大咖专区和顶部推荐数据数据
     */
    fun getBigShotData(map:Map<String,Any>): Observable<BaseAPIResponse<ExpertSearchTopShowBean>>

}