package com.yidianling.consultant.model


import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.consultant.bean.*
import com.yidianling.consultant.model.bean.*
import io.reactivex.Observable
import retrofit2.http.*


/**
 * Created by zqk on 17-10-26.
 */
interface SearchApi {

    companion object {

        var instance: SearchApi? = null

        fun getSearchApi(): SearchApi {
            if (instance == null) {
                instance = YDLHttpUtils.obtainApi(SearchApi::class.java)
            }
            return instance!!
        }
    }

    //服务列表头部
    @POST("product/list-head")
    @FormUrlEncoded
    fun listHead(@FieldMap maps: Map<String, String>): Observable<BaseResponse<HeadData>>

    //搜索条件
    @GET("consult/search/v3/conditions")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun searchConditions(@Query("cateSource") cateSource: Int): Observable<BaseAPIResponse<HeadData>>

    //查询八大类目包括
    @GET("consult/search/v3/mix-cates")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun searchEightCategoryHotWord(): Observable<BaseAPIResponse<MutableList<CateItem>>>

    //查询功能词、底纹词
    //(1热门词，2底纹词，3跳转词)
    @POST("function/word/queryList")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun searchFunctionWord(@Body map: Map<String, @JvmSuppressWildcards Any>): Observable<BaseAPIResponse<MutableList<FunctionWordBean>>>

    //查询功能词、底纹词
    //(1热门词，2底纹词，3跳转词)
    @POST("function/word/queryList")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun searchFunctionWordApi(@Body map: Map<String, @JvmSuppressWildcards Any>): Observable<BaseAPIResponse<MutableList<FunctionWordConsultBean>>>

    /**
     * 新咨询师列表接口(包含搜索、筛选咨询师)
     */
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "X-App-Id: plough_cloud")
    @POST("smart-rank/v1/search")
    fun getExpertList(@Body map: Map<String, @JvmSuppressWildcards Any>): Observable<BaseAPIResponse<ExpertBean>>

    /**
     * 获取搜索联想词
     */
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    @POST("dmp/v1/searchsuggest")
    fun getSearchWords(@Body map: Map<String,@JvmSuppressWildcards Any>):Observable<BaseAPIResponse<SearchWordsBean>>


    //搜索页面接口
    @retrofit2.http.Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("home/search-page")
    fun searchPage(): Observable<BaseAPIResponse<HotSearchBean>>

    //筛选结果计数
    @retrofit2.http.Headers("Content-Type:application/json")
    @GET
    fun getFilterCount(@Url url: String?): Observable<BaseAPIResponse<Int>>

    //导医
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("consult/assistant/guide-switch")
    fun getConsultAssistantRequest(@Query("switchKey") switchKey: String): Observable<BaseAPIResponse<Boolean>>

    //获取咨询助理uid
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @POST("doctor/querySpecialTopic")
    fun getBigShotData(@Body map: Map<String,@JvmSuppressWildcards Any>): Observable<BaseAPIResponse<ExpertSearchTopShowBean>>


    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    @GET("testGeneral/daoyi/setting")
    fun getGuideData(): Observable<BaseAPIResponse<Map<String, List<GuideBean>>>>

    //8-22点跳自主，其他时间跳导医，
    // 0 自主默认
    //1 自主
    //2 导医
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @GET("consult/assistant/chat-time-setting")
    fun getJumpTypeRequest(): Observable<BaseAPIResponse<Int>>

    /**
     * 100 有配置接口
     * */
    @GET("consult/assistant/chat-route-config")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    fun getChatRouteConfig(
        @Query("location") location: Int,
        @Query("naviType") naviType: String = "1"
    ): Observable<BaseAPIResponse<Long>>

    //根据IP地址获取城市
    @GET("region/ip-region")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    fun getCityByIp(): Observable<BaseAPIResponse<ConsultantRegionBean>>


    //搜索条件
    @GET("consult/user/order/promptPayment")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun promptPayment(): Observable<BaseAPIResponse<PromptPaymentBean>>


}