package com.yidianling.consultant.preview;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;

import com.blankj.utilcode.util.ScreenUtils;
import com.bumptech.glide.Glide;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.yidianling.consultant.R;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * @author fq
 */
public class GridPreviewActivity extends BaseActivity {

    private ArrayList<UserViewInfo> mThumbViewInfoList = new ArrayList<>();

    MyListAdapter adapter;
    private GridView gridView;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true, true);
    }

    /**
     * 查找信息
     * 从第一个完整可见item逆序遍历，如果初始位置为0，则不执行方法内循环
     */
    private void computeBoundsBackward(int firstCompletelyVisiblePos) {
        for (int i = firstCompletelyVisiblePos; i < mThumbViewInfoList.size(); i++) {
            View itemView = gridView.getChildAt(i - firstCompletelyVisiblePos);
            Rect bounds = new Rect();

            bounds.left = ScreenUtils.getScreenWidth() / 2;
            bounds.top = ScreenUtils.getScreenHeight() / 2;
            bounds.right = ScreenUtils.getScreenWidth() / 2;
            bounds.bottom = ScreenUtils.getScreenHeight() / 2;

//            if (itemView != null) {
//                ImageView thumbView = (ImageView) itemView.findViewById(R.id.iv);
//                thumbView.getGlobalVisibleRect(bounds);
//            }
            mThumbViewInfoList.get(i).setBounds(bounds);
        }
    }

    @Override
    protected int layoutResId() {
        return R.layout.consultant_picture_preview;
    }

    @Override
    protected void initDataAndEvent() {
        gridView = findViewById(R.id.grid_view);
        List<String> urls = ImageUrlConfig.getUrls();
        for (int i = 0; i < urls.size(); i++) {
            mThumbViewInfoList.add(new UserViewInfo(urls.get(i)));
        }

//        mThumbViewInfoList.add(4, new UserViewInfo("https://pic.ydlcdn.com/GGyHyDwKJ8.MP4", null));
        adapter = new MyListAdapter();
        gridView.setAdapter(adapter);
        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                computeBoundsBackward(gridView.getFirstVisiblePosition());
                GPreviewBuilder.form(GridPreviewActivity.this)
                        .setData(mThumbViewInfoList)
                        .setCurrentIndex(position)
                        .setFullscreen(true)
                        .setType(GPreviewBuilder.IndicatorType.Dot)
                        .start();

            }
        });
    }


    private class MyListAdapter extends BaseAdapter {

        @Override
        public int getCount() {
            return mThumbViewInfoList.size();
        }

        @Override
        public Object getItem(int position) {
            return mThumbViewInfoList.get(position);
        }

        @Override
        public long getItemId(int position) {
            return 0;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view = getLayoutInflater().inflate(R.layout.consultant_item_image, null);
            ImageView iv = (ImageView) view.findViewById(R.id.iv);
            Glide.with(GridPreviewActivity.this)
                    .load(mThumbViewInfoList.get(position).getUrl())
                    .into(iv);
            iv.setTag(R.id.iv, mThumbViewInfoList.get(position));
            return view;
        }
    }
}
