package com.yidianling.consultant.ui.view

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.PopupWindow
import com.yidianling.common.tools.RxImageTool
import com.yidianling.consultant.R
import com.yidianling.consultant.adapter.SortAdapter
import com.yidianling.consultant.layoutmanager.FlowLayoutManager
import com.yidianling.consultant.listener.OnCategoriesSelectedListener
import com.yidianling.consultant.model.bean.AllFilter
import com.yidianling.consultant.model.bean.ChildrenBean
import kotlinx.android.synthetic.main.consultant_ui_subject_popup_window.view.*

/**
 * 主题弹窗
 * Created by zqk on 17-9-15.
 */
class CategoryPopupWindow(context: Context,allFilter:AllFilter) : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dp2px(566f)) {
    private var view:View = LayoutInflater.from(context).inflate(R.layout.consultant_ui_subject_popup_window, null)
    var mAllFilter:AllFilter
    private lateinit var ivSortChildEducationOpen: ImageView
    private lateinit var ivSortEmotionalStress: ImageView
    private lateinit var ivSortLoveEmotion: ImageView
    private lateinit var ivSortMarriedFamily: ImageView
    private lateinit var ivSortPersonalGrowth: ImageView
    private lateinit var ivSortInterpersonalRelationship: ImageView
    private lateinit var ivSortCareerDevelopment: ImageView
    private lateinit var ivSortMentalHealth: ImageView
    var onSubjectsSelectedListener: OnCategoriesSelectedListener? = null
    private val childList = ArrayList<ChildrenBean>()
    private val stressList = ArrayList<ChildrenBean>()
    private val loveEmotionList = ArrayList<ChildrenBean>()
    private val marriedFamilyList = ArrayList<ChildrenBean>()
    private val personalGrowthList = ArrayList<ChildrenBean>()
    private val interpersonalRelationshipList = ArrayList<ChildrenBean>()
    private val careerDevelopmentList = ArrayList<ChildrenBean>()
    private val mentalHealthList = ArrayList<ChildrenBean>()
    private val signList = ArrayList<String>()      // 用于埋点
    private lateinit var childEducationAdapter:SortAdapter
    private lateinit var stressAdapter:SortAdapter
    private lateinit var loveEmotionAdapter:SortAdapter
    private lateinit var marriedFamilyAdapter:SortAdapter
    private lateinit var personalGrowthAdapter:SortAdapter
    private lateinit var interpersonalRelationshipAdapter:SortAdapter
    private lateinit var careerDevelopmentAdapter:SortAdapter
    private lateinit var mentalHealthAdapter:SortAdapter


    init {
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        mAllFilter = allFilter
        initView()
    }

    private fun initView(){
        inputMethodMode = INPUT_METHOD_NEEDED
        // 重置
        view.btn_reset.setOnClickListener {
            reset()
        }
        // 确定
        view.btnConfirm.setOnClickListener {
            onSubjectsSelectedListener?.onCategoriesSelected(signList)
            dismiss()
        }
        // 亲子教育
        val rvSortChildEducation = view.rv_sort_child_education
        ivSortChildEducationOpen = view.iv_sort_child_education_open
        childEducationAdapter = SortAdapter(childList)
        rvSortChildEducation.layoutManager = FlowLayoutManager()
        rvSortChildEducation.adapter = childEducationAdapter
        childEducationAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (childList[0].isSelected){
                    childList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(childList[0].cate_id)
                    mAllFilter.chooseChildIndexList.remove(position)
                    signList.remove("亲子教育")
                }else{
                    childList.forEachIndexed { index, _ ->
                        childList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(childList[0].cate_id)
                            signList.add("亲子教育")
                        }else{
                            mAllFilter.categoryId3List.remove(childList[index].cate_id)
                            signList.remove(childList[index].cate_name)
                        }
                    }
                    mAllFilter.chooseChildIndexList.add(position)
                }
            }else{
                if (!childList[position].isSelected&&childList[0].isSelected){
                    childList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(childList[0].cate_id)
                    signList.remove("亲子教育")
                }
                childList[position].isSelected = !childList[position].isSelected
                if (childList[position].isSelected){
                    mAllFilter.categoryId3List.add(childList[position].cate_id)
                    mAllFilter.chooseChildIndexList.add(position)
                    signList.add(childList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(childList[position].cate_id)
                    mAllFilter.chooseChildIndexList.remove(position)
                    signList.remove(childList[position].cate_name)
                }
            }
            childEducationAdapter.notifyDataSetChanged()
        }
        // 情绪压力
        val rvSortEmotionalStress = view.rv_sort_emotional_stress
        ivSortEmotionalStress = view.iv_sort_emotional_stress
        stressAdapter = SortAdapter(stressList)
        rvSortEmotionalStress.layoutManager = FlowLayoutManager()
        rvSortEmotionalStress.adapter = stressAdapter
        stressAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (stressList[0].isSelected){
                    stressList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(stressList[0].cate_id)
                    mAllFilter.chooseStressIndexList.remove(position)
                    signList.remove("情绪压力")
                }else{
                    stressList.forEachIndexed { index, _ ->
                        stressList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(stressList[0].cate_id)
                            signList.add("情绪压力")
                        }else{
                            mAllFilter.categoryId3List.remove(stressList[index].cate_id)
                            signList.remove(stressList[index].cate_name)
                        }
                    }
                    mAllFilter.chooseStressIndexList.add(position)
                }
            }else{
                if (!stressList[position].isSelected&&stressList[0].isSelected){
                    stressList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(stressList[0].cate_id)
                    signList.remove("情绪压力")
                }
                stressList[position].isSelected = !stressList[position].isSelected
                if (stressList[position].isSelected){
                    mAllFilter.categoryId3List.add(stressList[position].cate_id)
                    mAllFilter.chooseStressIndexList.add(position)
                    signList.add(stressList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(stressList[position].cate_id)
                    mAllFilter.chooseStressIndexList.remove(position)
                    signList.remove(stressList[position].cate_name)
                }
            }
            stressAdapter.notifyDataSetChanged()
        }
        // 恋爱情感
        val rvLoveEmotion = view.rv_sort_love_emotion
        ivSortLoveEmotion = view.iv_sort_love_emotion
        loveEmotionAdapter = SortAdapter(loveEmotionList)
        rvLoveEmotion.layoutManager = FlowLayoutManager()
        rvLoveEmotion.adapter = loveEmotionAdapter
        loveEmotionAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (loveEmotionList[0].isSelected){
                    loveEmotionList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(loveEmotionList[0].cate_id)
                    mAllFilter.chooseLoveEmotionIndexList.remove(position)
                    signList.remove("恋爱情感")
                }else{
                    loveEmotionList.forEachIndexed { index, _ ->
                        loveEmotionList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(loveEmotionList[0].cate_id)
                            signList.add("恋爱情感")
                        }else{
                            mAllFilter.categoryId3List.remove(loveEmotionList[index].cate_id)
                            signList.remove(loveEmotionList[index].cate_name)
                        }
                    }
                    mAllFilter.chooseLoveEmotionIndexList.add(position)
                }
            }else{
                if (!loveEmotionList[position].isSelected&&loveEmotionList[0].isSelected){
                    loveEmotionList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(loveEmotionList[0].cate_id)
                    signList.remove("恋爱情感")
                }
                loveEmotionList[position].isSelected = !loveEmotionList[position].isSelected
                if (loveEmotionList[position].isSelected){
                    mAllFilter.categoryId3List.add(loveEmotionList[position].cate_id)
                    mAllFilter.chooseLoveEmotionIndexList.add(position)
                    signList.add(loveEmotionList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(loveEmotionList[position].cate_id)
                    mAllFilter.chooseLoveEmotionIndexList.remove(position)
                    signList.remove(loveEmotionList[position].cate_name)
                }
            }
            loveEmotionAdapter.notifyDataSetChanged()
        }
        // 婚姻家庭
        ivSortMarriedFamily = view.iv_sort_married_family
        val rvSortMarriedFamily = view.rv_sort_married_family
        marriedFamilyAdapter = SortAdapter(marriedFamilyList)
        rvSortMarriedFamily.layoutManager = FlowLayoutManager()
        rvSortMarriedFamily.adapter = marriedFamilyAdapter
        marriedFamilyAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (marriedFamilyList[0].isSelected){
                    marriedFamilyList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(marriedFamilyList[0].cate_id)
                    mAllFilter.chooseMarriedFamilyIndexList.remove(position)
                    signList.remove("婚姻家庭")
                }else{
                    marriedFamilyList.forEachIndexed { index, _ ->
                        marriedFamilyList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(marriedFamilyList[0].cate_id)
                            signList.add("婚姻家庭")
                        }else{
                            mAllFilter.categoryId3List.remove(marriedFamilyList[index].cate_id)
                            signList.remove(marriedFamilyList[index].cate_name)
                        }
                    }
                    mAllFilter.chooseMarriedFamilyIndexList.add(position)
                }
            }else{
                if (!marriedFamilyList[position].isSelected&&marriedFamilyList[0].isSelected){
                    marriedFamilyList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(marriedFamilyList[0].cate_id)
                    signList.remove("婚姻家庭")
                }
                marriedFamilyList[position].isSelected = !marriedFamilyList[position].isSelected
                if (marriedFamilyList[position].isSelected){
                    mAllFilter.categoryId3List.add(marriedFamilyList[position].cate_id)
                    mAllFilter.chooseMarriedFamilyIndexList.add(position)
                    signList.add(marriedFamilyList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(marriedFamilyList[position].cate_id)
                    mAllFilter.chooseMarriedFamilyIndexList.remove(position)
                    signList.remove(marriedFamilyList[position].cate_name)
                }
            }
            marriedFamilyAdapter.notifyDataSetChanged()
        }
        // 个人成长
        ivSortPersonalGrowth = view.iv_sort_personal_growth
        val rvSortPersonalGrowth = view.rv_sort_personal_growth
        personalGrowthAdapter = SortAdapter(personalGrowthList)
        rvSortPersonalGrowth.layoutManager = FlowLayoutManager()
        rvSortPersonalGrowth.adapter = personalGrowthAdapter
        personalGrowthAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (personalGrowthList[0].isSelected){
                    personalGrowthList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(personalGrowthList[0].cate_id)
                    mAllFilter.choosePersonalGrowthIndexList.remove(position)
                    signList.remove("个人成长")
                }else{
                    personalGrowthList.forEachIndexed { index, _ ->
                        personalGrowthList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(personalGrowthList[0].cate_id)
                            signList.add("个人成长")
                        }else{
                            mAllFilter.categoryId3List.remove(personalGrowthList[index].cate_id)
                            signList.remove(personalGrowthList[index].cate_name)
                        }
                    }
                    mAllFilter.choosePersonalGrowthIndexList.add(position)
                }
            }else{
                if (!personalGrowthList[position].isSelected&&personalGrowthList[0].isSelected){
                    personalGrowthList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(childList[0].cate_id)
                    signList.remove("个人成长")
                }
                personalGrowthList[position].isSelected = !personalGrowthList[position].isSelected
                if (personalGrowthList[position].isSelected){
                    mAllFilter.categoryId3List.add(personalGrowthList[position].cate_id)
                    mAllFilter.choosePersonalGrowthIndexList.add(position)
                    signList.add(personalGrowthList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(personalGrowthList[position].cate_id)
                    mAllFilter.choosePersonalGrowthIndexList.remove(position)
                    signList.remove(personalGrowthList[position].cate_name)
                }
            }
            personalGrowthAdapter.notifyDataSetChanged()
        }
        // 人际关系
        ivSortInterpersonalRelationship = view.iv_sort_interpersonal_relationship
        val rvSortInterpersonalRelationship = view.rv_sort_interpersonal_relationship
        interpersonalRelationshipAdapter = SortAdapter(interpersonalRelationshipList)
        rvSortInterpersonalRelationship.layoutManager = FlowLayoutManager()
        rvSortInterpersonalRelationship.adapter = interpersonalRelationshipAdapter
        interpersonalRelationshipAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (interpersonalRelationshipList[0].isSelected){
                    interpersonalRelationshipList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(interpersonalRelationshipList[0].cate_id)
                    mAllFilter.chooseInterpersonalRelationshipIndexList.remove(position)
                    signList.remove("人际关系")
                }else{
                    interpersonalRelationshipList.forEachIndexed { index, _ ->
                        interpersonalRelationshipList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(interpersonalRelationshipList[0].cate_id)
                            signList.add("人际关系")
                        }else{
                            mAllFilter.categoryId3List.remove(interpersonalRelationshipList[index].cate_id)
                            signList.remove(interpersonalRelationshipList[index].cate_name)
                        }
                    }
                    mAllFilter.chooseInterpersonalRelationshipIndexList.add(position)
                }
            }else{
                if (!interpersonalRelationshipList[position].isSelected&&interpersonalRelationshipList[0].isSelected){
                    interpersonalRelationshipList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(interpersonalRelationshipList[0].cate_id)
                    signList.remove("人际关系")
                }
                interpersonalRelationshipList[position].isSelected = !interpersonalRelationshipList[position].isSelected
                if (interpersonalRelationshipList[position].isSelected){
                    mAllFilter.categoryId3List.add(interpersonalRelationshipList[position].cate_id)
                    mAllFilter.chooseInterpersonalRelationshipIndexList.add(position)
                    signList.add(interpersonalRelationshipList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(interpersonalRelationshipList[position].cate_id)
                    mAllFilter.chooseInterpersonalRelationshipIndexList.remove(position)
                    signList.remove(interpersonalRelationshipList[position].cate_name)
                }
            }
            interpersonalRelationshipAdapter.notifyDataSetChanged()
        }
        // 职场发展
        ivSortCareerDevelopment = view.iv_sort_career_development
        val rvSortCareerDevelopment = view.rv_sort_career_development
        careerDevelopmentAdapter = SortAdapter(careerDevelopmentList)
        rvSortCareerDevelopment.layoutManager = FlowLayoutManager()
        rvSortCareerDevelopment.adapter = careerDevelopmentAdapter
        careerDevelopmentAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (careerDevelopmentList[0].isSelected){
                    careerDevelopmentList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(childList[0].cate_id)
                    mAllFilter.chooseCareerDevelopmentIndexList.remove(position)
                    signList.remove("职场发展")
                }else{
                    careerDevelopmentList.forEachIndexed { index, _ ->
                        careerDevelopmentList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(careerDevelopmentList[0].cate_id)
                            signList.add("职场发展")
                        }else{
                            mAllFilter.categoryId3List.remove(careerDevelopmentList[index].cate_id)
                            signList.remove(careerDevelopmentList[index].cate_name)
                        }
                    }
                    mAllFilter.chooseCareerDevelopmentIndexList.add(position)
                }
            }else{
                if (!careerDevelopmentList[position].isSelected&&careerDevelopmentList[0].isSelected){
                    careerDevelopmentList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(careerDevelopmentList[0].cate_id)
                    signList.remove("职场发展")
                }
                careerDevelopmentList[position].isSelected = !careerDevelopmentList[position].isSelected
                if (careerDevelopmentList[position].isSelected){
                    mAllFilter.categoryId3List.add(careerDevelopmentList[position].cate_id)
                    mAllFilter.chooseCareerDevelopmentIndexList.add(position)
                    signList.add(careerDevelopmentList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(careerDevelopmentList[position].cate_id)
                    mAllFilter.chooseCareerDevelopmentIndexList.remove(position)
                    signList.remove(careerDevelopmentList[position].cate_name)
                }
            }
            careerDevelopmentAdapter.notifyDataSetChanged()
        }
        // 心理健康
        ivSortMentalHealth = view.iv_sort_mental_health
        val rvSortMentalHealth = view.rv_sort_mental_health
        mentalHealthAdapter = SortAdapter(mentalHealthList)
        rvSortMentalHealth.layoutManager = FlowLayoutManager()
        rvSortMentalHealth.adapter = mentalHealthAdapter
        mentalHealthAdapter.setOnItemClickListener { adapter, view, position ->
            if (position==0){
                if (mentalHealthList[0].isSelected){
                    mentalHealthList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(mentalHealthList[0].cate_id)
                    mAllFilter.chooseMentalHealthIndexList.remove(position)
                    signList.remove("心理健康")
                }else{
                    mentalHealthList.forEachIndexed { index, _ ->
                        mentalHealthList[index].isSelected = index==0
                        if (index==0){
                            mAllFilter.categoryId2List.add(mentalHealthList[0].cate_id)
                            signList.add("心理健康")
                        }else{
                            mAllFilter.categoryId3List.remove(mentalHealthList[index].cate_id)
                            signList.remove(mentalHealthList[index].cate_name)
                        }
                    }
                    mAllFilter.chooseMentalHealthIndexList.add(position)
                }
            }else{
                if (!mentalHealthList[position].isSelected&&mentalHealthList[0].isSelected){
                    mentalHealthList[0].isSelected = false
                    mAllFilter.categoryId2List.remove(mentalHealthList[0].cate_id)
                    signList.remove("心理健康")
                }
                mentalHealthList[position].isSelected = !mentalHealthList[position].isSelected
                if (mentalHealthList[position].isSelected){
                    mAllFilter.categoryId3List.add(mentalHealthList[position].cate_id)
                    mAllFilter.chooseMentalHealthIndexList.add(position)
                    signList.add(mentalHealthList[position].cate_name)
                }else{
                    mAllFilter.categoryId3List.remove(mentalHealthList[position].cate_id)
                    mAllFilter.chooseMentalHealthIndexList.remove(position)
                    signList.remove(mentalHealthList[position].cate_name)
                }
            }
            mentalHealthAdapter.notifyDataSetChanged()
        }

        /**
         * 原来的筛选项写在PopupWindow里边，数据太多的情况下，弹窗第一次打开很慢，所以这里做了一个骚操作，
         * 先加载亲子教育和情绪压力的12条数据，之后再加载全部，后期时间充裕可以优化，直接做到页面里边，不要写在PopupWindow里边
         */
        // 亲子教育
        if (mAllFilter.childList.size>12){
            childList.addAll(mAllFilter.childList.subList(0,12))
        }else{
            childList.addAll(mAllFilter.childList)
        }
        childEducationAdapter.notifyDataSetChanged()
        if (mAllFilter.childList.size>12){
            ivSortChildEducationOpen.visibility = View.VISIBLE
            view.ll_sort_child_education_open.setOnClickListener {
                val params = rvSortChildEducation.layoutParams as LinearLayout.LayoutParams
                if (!childEducationAdapter.isVisible){
                    if (childList.size<=12){
                        childList.addAll(mAllFilter.childList.subList(12,mAllFilter.childList.size))
                        childEducationAdapter.notifyDataSetChanged()
                    }
                    childEducationAdapter.setAllVisible()
                    ivSortChildEducationOpen.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    rvSortChildEducation.layoutParams = params
                }else{
                    childEducationAdapter.setGone()
                    ivSortChildEducationOpen.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    rvSortChildEducation.layoutParams = params
                }
            }
        }
        // 情绪压力
        if (mAllFilter.stressList.size>12){
            stressList.addAll(mAllFilter.stressList.subList(0,12))
        }else{
            stressList.addAll(mAllFilter.stressList)
        }
        stressAdapter.notifyDataSetChanged()
        if (mAllFilter.stressList.size>12){
            ivSortEmotionalStress.visibility = View.VISIBLE
            view.ll_sort_emotional_stress.setOnClickListener {
                val params = rvSortEmotionalStress.layoutParams as LinearLayout.LayoutParams
                if (!stressAdapter.isVisible){
                    if (stressList.size<=12){
                        stressList.addAll(mAllFilter.stressList.subList(12,mAllFilter.stressList.size))
                        stressAdapter.notifyDataSetChanged()
                    }
                    stressAdapter.setAllVisible()
                    ivSortEmotionalStress.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    rvSortEmotionalStress.layoutParams = params
                }else{
                    stressAdapter.setGone()
                    ivSortEmotionalStress.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    rvSortEmotionalStress.layoutParams = params
                }
            }
        }
    }

    fun updateData(){
        //  恋爱情感
        loveEmotionList.addAll(mAllFilter.loveEmotionList)
        loveEmotionAdapter.notifyDataSetChanged()
        if (loveEmotionList.size>12){
            ivSortLoveEmotion.visibility = View.VISIBLE
            view.ll_sort_love_emotion.setOnClickListener {
                val params = view.rv_sort_love_emotion.layoutParams as LinearLayout.LayoutParams
                if (!loveEmotionAdapter.isVisible){
                    loveEmotionAdapter.setAllVisible()
                    ivSortLoveEmotion.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    view.rv_sort_love_emotion.layoutParams = params
                }else{
                    loveEmotionAdapter.setGone()
                    ivSortLoveEmotion.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    view.rv_sort_love_emotion.layoutParams = params
                }
            }
        }
        //  婚姻家庭
        marriedFamilyList.addAll(mAllFilter.marriedFamilyList)
        marriedFamilyAdapter.notifyDataSetChanged()
        if (marriedFamilyList.size>12){
            ivSortMarriedFamily.visibility = View.VISIBLE
            view.ll_sort_married_family.setOnClickListener {
                val params = view.rv_sort_married_family.layoutParams as LinearLayout.LayoutParams
                if (!marriedFamilyAdapter.isVisible){
                    marriedFamilyAdapter.setAllVisible()
                    ivSortMarriedFamily.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    view.rv_sort_married_family.layoutParams = params
                }else{
                    marriedFamilyAdapter.setGone()
                    ivSortMarriedFamily.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    view.rv_sort_married_family.layoutParams = params
                }
            }
        }
        //  个人成长
        personalGrowthList.addAll(mAllFilter.personalGrowthList)
        personalGrowthAdapter.notifyDataSetChanged()
        if (personalGrowthList.size>12){
            ivSortPersonalGrowth.visibility = View.VISIBLE
            view.ll_sort_personal_growth.setOnClickListener {
                val params = view.rv_sort_personal_growth.layoutParams as LinearLayout.LayoutParams
                if (!personalGrowthAdapter.isVisible){
                    personalGrowthAdapter.setAllVisible()
                    ivSortPersonalGrowth.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    view.rv_sort_personal_growth.layoutParams = params
                }else{
                    personalGrowthAdapter.setGone()
                    ivSortPersonalGrowth.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    view.rv_sort_personal_growth.layoutParams = params
                }
            }
        }
        //  人际关系
        interpersonalRelationshipList.addAll(mAllFilter.interpersonalRelationshipList)
        interpersonalRelationshipAdapter.notifyDataSetChanged()
        if (interpersonalRelationshipList.size>12){
            ivSortInterpersonalRelationship.visibility = View.VISIBLE
            view.ll_sort_interpersonal_relationship.setOnClickListener {
                val params = view.rv_sort_interpersonal_relationship.layoutParams as LinearLayout.LayoutParams
                if (!interpersonalRelationshipAdapter.isVisible){
                    interpersonalRelationshipAdapter.setAllVisible()
                    ivSortInterpersonalRelationship.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    view.rv_sort_interpersonal_relationship.layoutParams = params
                }else{
                    interpersonalRelationshipAdapter.setGone()
                    ivSortInterpersonalRelationship.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    view.rv_sort_interpersonal_relationship.layoutParams = params
                }
            }
        }
        //  职场发展
        careerDevelopmentList.addAll(mAllFilter.careerDevelopmentList)
        careerDevelopmentAdapter.notifyDataSetChanged()
        if (careerDevelopmentList.size>12){
            ivSortCareerDevelopment.visibility = View.VISIBLE
            view.ll_sort_career_development.setOnClickListener {
                val params = view.rv_sort_career_development.layoutParams as LinearLayout.LayoutParams
                if (!careerDevelopmentAdapter.isVisible){
                    careerDevelopmentAdapter.setAllVisible()
                    ivSortCareerDevelopment.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    view.rv_sort_career_development.layoutParams = params
                }else{
                    careerDevelopmentAdapter.setGone()
                    ivSortCareerDevelopment.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    view.rv_sort_career_development.layoutParams = params
                }
            }
        }
        //  心理健康
        mentalHealthList.addAll(mAllFilter.mentalHealthList)
        mentalHealthAdapter.notifyDataSetChanged()
        if (mentalHealthList.size>12){
            ivSortMentalHealth.visibility = View.VISIBLE
            view.ll_sort_mental_health.setOnClickListener {
                val params = view.rv_sort_mental_health.layoutParams as LinearLayout.LayoutParams
                if (!mentalHealthAdapter.isVisible){
                    mentalHealthAdapter.setAllVisible()
                    ivSortMentalHealth.setImageResource(R.drawable.consultant_ic_sort_open)
                    // 展开的布局设置自适应
                    params.height = LinearLayout.LayoutParams.WRAP_CONTENT
                    view.rv_sort_mental_health.layoutParams = params
                }else{
                    mentalHealthAdapter.setGone()
                    ivSortMentalHealth.setImageResource(R.drawable.consultant_ic_sort_close)
                    // 关闭的时候布局设置为固定高度
                    params.height = RxImageTool.dp2px(138f)
                    view.rv_sort_mental_health.layoutParams = params
                }
            }
        }
    }

    /**
     * 重置
     */
    fun reset(){
        if (mAllFilter.chooseChildIndexList.size>0){
            mAllFilter.chooseChildIndexList.forEach {
                childList[it].isSelected = false
            }
            childEducationAdapter.notifyDataSetChanged()
        }
        if (mAllFilter.chooseStressIndexList.size>0){
            mAllFilter.chooseStressIndexList.forEach{
                stressList[it].isSelected = false
            }
            stressAdapter.notifyDataSetChanged()
        }
        if (mAllFilter.chooseLoveEmotionIndexList.size>0){
            mAllFilter.chooseLoveEmotionIndexList.forEach {
                loveEmotionList[it].isSelected = false
            }
            loveEmotionAdapter.notifyDataSetChanged()
        }
        if (mAllFilter.chooseMarriedFamilyIndexList.size>0){
            mAllFilter.chooseMarriedFamilyIndexList.forEach {
                marriedFamilyList[it].isSelected = false
            }
            marriedFamilyAdapter.notifyDataSetChanged()
        }
        if (mAllFilter.choosePersonalGrowthIndexList.size>0){
            mAllFilter.choosePersonalGrowthIndexList.forEach{
                personalGrowthList[it].isSelected = false
            }
            personalGrowthAdapter.notifyDataSetChanged()
        }
        if (mAllFilter.chooseInterpersonalRelationshipIndexList.size>0){
            mAllFilter.chooseInterpersonalRelationshipIndexList.forEach {
                interpersonalRelationshipList[it].isSelected = false
            }
            interpersonalRelationshipAdapter.notifyDataSetChanged()
        }
        if (mAllFilter.chooseCareerDevelopmentIndexList.size>0){
            mAllFilter.chooseCareerDevelopmentIndexList.forEach {
                careerDevelopmentList[it].isSelected = false
            }
            careerDevelopmentAdapter.notifyDataSetChanged()
        }
        if (mAllFilter.chooseMentalHealthIndexList.size>0){
            mAllFilter.chooseMentalHealthIndexList.forEach {
                mentalHealthList[it].isSelected = false
            }
            mentalHealthAdapter.notifyDataSetChanged()
        }
        mAllFilter.categoryId2List.clear()
        mAllFilter.categoryId3List.clear()
        signList.clear()
    }
}