package com.yidianling.consultant.ui.view.topView

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.consultant.R
import com.yidianling.consultant.bean.ExpertSearchRecommandBean
import com.yidianling.consultant.constants.ConsultBIConstants
import kotlinx.android.synthetic.main.consultant_expert_search_top_item_view.view.*

class RecommendItemView : LinearLayout {


    constructor(context: Context) : super(context) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initView()
    }

    private var mContext: Context? = null


    private fun initView() {

        val mWidth: Int = RxDeviceTool.getScreenWidth(mContext) / 2
        val mHeight: Int = RxImageTool.dp2px(60f)

        val params = LayoutParams(
            mWidth,
            mHeight
        )
        params.height = mHeight
        layoutParams = params

        orientation = HORIZONTAL
        View.inflate(mContext, R.layout.consultant_expert_search_top_item_view, this)
    }

    fun setData(bean: ExpertSearchRecommandBean) {

        if (bean.topicImages.isNotEmpty() && bean.topicImages.size > 0 && bean.topicImages[0].imageUrl.isNotEmpty()) {
            mContext?.let { GlideApp.with(it).load(bean.topicImages[0].imageUrl).into(top_item_img) }
        }

        top_item_title.text = bean.specialTopicTitle?:""

        top_item_desc.text = bean.specialTopicSubhead?:""

        setOnClickListener {
            val h5Params = H5Params(bean.specialTopicUrl, null)
            NewH5Activity.start(context, h5Params)
            ActionCountUtils.count(
                ConsultBIConstants.PART_ID_CONSULT_COUNSELOR_LIST_PAGE + "|" + ConsultBIConstants.POSITION_CONSULT_COUNSELOR_LIST_BANNER_CLICK,
                bean.specialTopicName
            )

        }

    }
}