package com.yidianling.course.courseNew;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.RelativeLayout;
import android.widget.TextView;

import in.srain.cube.views.loadmore.LoadMoreContainer;
import in.srain.cube.views.loadmore.LoadMoreUIHandler;

/**
 * Created by Jim on 2018/7/20 0020.
 */

public class LoadMoreView extends RelativeLayout implements LoadMoreUIHandler {

    private TextView mTextView;

    public LoadMoreView(Context context) {
        this(context, null);
    }

    public LoadMoreView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadMoreView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        setupViews();
    }

    private void setupViews() {
        LayoutInflater.from(getContext()).inflate(in.srain.cube.R.layout.cube_views_load_more_default_footer, this);
        mTextView = (TextView) findViewById(in.srain.cube.R.id.cube_views_load_more_default_footer_text_view);
        mTextView.setTextColor(Color.parseColor("#909599"));
        mTextView.setTextSize(11);
    }

    @Override
    public void onLoading(LoadMoreContainer container) {
        setVisibility(VISIBLE);
        mTextView.setText(in.srain.cube.R.string.cube_views_load_more_loading);
    }

    @Override
    public void onLoadFinish(LoadMoreContainer container, boolean empty, boolean hasMore) {
        if (!hasMore) {
            setVisibility(VISIBLE);
            if (empty) {
                mTextView.setText(in.srain.cube.R.string.cube_views_load_more_loaded_empty);
            } else {
                mTextView.setText("没有更多咯～");
            }
        } else {
            setVisibility(INVISIBLE);
        }
    }

    @Override
    public void onWaitToLoadMore(LoadMoreContainer container) {
        setVisibility(VISIBLE);
        mTextView.setText(in.srain.cube.R.string.cube_views_load_more_click_to_load_more);
    }
}