package com.yidianling.course.coursePlay

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Intent
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.utils.log.LogHelper
import com.yidianling.common.tools.ToastUtil
import com.yidianling.course.CourseConstants
import com.yidianling.course.R
import com.yidianling.course.net.Command
import com.yidianling.course.net.CourseRetrofitUtils
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.activity_course_commeny.*

/**
 * @author jiucheng
 * @描述:课程写评价页面
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/7/2
 */
@Route(path = "/course/comment")
class CourseCommentActivity : BaseActivity() {
    private var courseId: String? = null

    companion object {
        private const val COURSE_ID = "course_id"
        fun startActivity(activity: Activity, courseId: String) {
            var intent = Intent(activity, CourseCommentActivity::class.java)
            intent.putExtra(COURSE_ID, courseId)
            activity.startActivity(intent)
        }
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, statusBarDarkMode = true)
    }
    override fun layoutResId(): Int {
        return R.layout.activity_course_commeny
    }

    override fun initDataAndEvent() {
        courseId = intent.getStringExtra(COURSE_ID)
        if (TextUtils.isEmpty(courseId)) {
            ToastUtil.toastShort("参数错误，请重试")
            return
        }
        iv_back.setOnClickListener {
            finish()
        }

        tv_left_menu.setOnClickListener {
            if (TextUtils.isEmpty(et_comment.text.toString())) {
                ToastUtil.toastShort("请输入评论内容")
                return@setOnClickListener
            }
            commitReply(et_comment.text.toString())
        }

        et_comment.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(s: Editable?) {
                if (TextUtils.isEmpty(s)) {
                    tv_input_length.text = "0"
                    tv_input_length.setTextColor(resources.getColor(R.color.course_color_B3B3B3))
                } else {
                    tv_input_length.text = s!!.length.toString()
                    tv_input_length.setTextColor(resources.getColor(R.color.course_color_242424))
                }
            }

            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            }
        })
    }

    //提交评论
    @SuppressLint("CheckResult")
    private fun commitReply(content: String) {
        showProgressDialog(null)
        val cmd = Command.CourseCommitReply(courseId!!.toInt(), content)
        CourseRetrofitUtils.commitCourseReply(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ resp ->
                    dismissProgressDialog()
                    if (resp.code == 200) {
                        ToastUtil.toastShort(resp.msg)

                        val h5Params = H5Params(CourseConstants.COURSE_COMMENT_H5 + courseId, "全部评价")
                        NewH5Activity.start(this@CourseCommentActivity, h5Params)

                        this@CourseCommentActivity.finish()
                    } else {
                        ToastUtil.toastShort(resp.msg)
                        LogHelper.getInstance().writeLogSync("提交评论失败：" + resp.msg)
                    }
                }, { t ->
                    dismissProgressDialog()
                    CourseRetrofitUtils.handleError(this, t)
                    LogHelper.getInstance().writeLogSync("提交评论失败：" + t.message)
                })
    }
}
