package com.yidianling.dynamic.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.RecommendTopic;
import com.ydl.ydlcommon.view.widgets.RoundImageView;

import java.util.List;

/**
 * Created by xiongyu on 2017/3/14.
 */

public class AllTopicAdapter extends RecyclerView.Adapter<AllTopicViewHolder> {
    protected Context mContext;
    protected List<RecommendTopic> mDatas;
    protected LayoutInflater mInflater;
    public interface OnItemClickLister {
        void onItemClick(View view, int position);

        void onItemLongClick(View view, int position);
    }

    public interface OnFocusClickLister {
        void onFocusClick(View view, int position);

        void onFocusLongClick(View view, int position);
    }

    private OnFocusClickLister mOnFocusClickLister;
    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }
    public void setmOnFocusClickLister(OnFocusClickLister lister) {
        this.mOnFocusClickLister = lister;
    }

    public AllTopicAdapter(List<RecommendTopic> mDatas, Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public AllTopicViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view= mInflater.inflate(R.layout.dynamic_item_alltopic,parent,false);
        AllTopicViewHolder viewHolder= new AllTopicViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(AllTopicViewHolder holder, int position) {
        RecommendTopic recommendTopic=mDatas.get(position);
        String img_url=recommendTopic.getImg_bg_url();
        String topic_title=recommendTopic.getTopic_title();
        String trend_num=recommendTopic.getTrend_num();
        String focus_num=recommendTopic.getFocus_num();
        String focus_state=recommendTopic.getFocus_state();
        GlideApp.with(mContext)
                .load(img_url)
                .placeholder(R.drawable.dynamic_default_img)
                .error(R.drawable.dynamic_default_img)
                .into(holder.item_topic_iv);
        holder.item_topic_title_tv.setText(topic_title);
        holder.item_topic_trend_num_tv.setText(String.format("动态 %s", trend_num));
        holder.item_topic_focus_num_tv.setText(String.format("关注 %s", focus_num));
        if("1".equals(focus_state)){//1已关注，2未关注
            holder.item_topic_trend_focus_rel.setVisibility(View.GONE);
        }else if("2".equals(focus_state)){
            holder.item_topic_trend_focus_rel.setVisibility(View.VISIBLE);
            holder.item_topic_trend_focus_tv.setText("+ 关注");
        }
        setUpItemEvent(holder);
        setUpFocusEvent(holder);
    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }
    /**
     * 添加股据到指定位置
     * @param pos 数据添加的位置
     * @param recommendtopic 数据
     */
    public  void addData(int pos,RecommendTopic recommendtopic){
        mDatas.add(recommendtopic);
        notifyItemInserted(pos);
    }

    /**
     * 删除股票到指定位置
     * @param pos
     */
    public void deleteData(int pos){
        mDatas.remove(pos);
        notifyItemRemoved(pos);
    }

    public void updateDate(List<RecommendTopic> mDatas) {
        this.mDatas = mDatas;
        notifyDataSetChanged();
    }

    /**
     * 给item添加监听
     * @param holder
     */
    protected  void setUpItemEvent(final AllTopicViewHolder holder){
        if(mOnItemClickLister!=null){
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView,layoutPosition);

                }
            });
            holder.itemView.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemLongClick(holder.itemView,layoutPosition);
                    return false;
                }
            });
        }
    }

    /**
     * 给关注按钮添加监听
     * @param holder
     */
    protected  void setUpFocusEvent(final AllTopicViewHolder holder){
        if(mOnFocusClickLister!=null){
            holder.item_topic_trend_focus_rel.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnFocusClickLister.onFocusClick(holder.item_topic_trend_focus_rel,layoutPosition);

                }
            });
            holder.item_topic_trend_focus_rel.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnFocusClickLister.onFocusLongClick(holder.item_topic_trend_focus_rel,layoutPosition);
                    return false;
                }
            });
        }
    }

}

class AllTopicViewHolder extends RecyclerView.ViewHolder{
    RoundImageView item_topic_iv;
    TextView item_topic_title_tv,item_topic_focus_num_tv,item_topic_trend_num_tv,item_topic_trend_focus_tv;
    RelativeLayout item_topic_trend_focus_rel;
    public AllTopicViewHolder(View itemView) {
        super(itemView);
        item_topic_iv=(RoundImageView)itemView.findViewById(R.id.item_topic_iv);
        item_topic_title_tv=(TextView)itemView.findViewById(R.id.item_topic_title_tv);
        item_topic_focus_num_tv=(TextView)itemView.findViewById(R.id.item_topic_focus_num_tv);
        item_topic_trend_num_tv=(TextView)itemView.findViewById(R.id.item_topic_trend_num_tv);
        item_topic_trend_focus_tv=(TextView)itemView.findViewById(R.id.item_topic_trend_focus_tv);
        item_topic_trend_focus_rel=(RelativeLayout)itemView.findViewById(R.id.item_topic_trend_focus_rel);
    }
}