package com.yidianling.dynamic.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.text.style.ImageSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.RecommendedDiscuss;
import com.ydl.ydlcommon.utils.MoonUtil;

import java.util.List;

/**
 * Created by xiongyu on 2017/3/14.
 */

public class RecommendDicussAdapter extends RecyclerView.Adapter<RecommendDicussViewHolder> {
    protected Context mContext;
    protected List<RecommendedDiscuss> mDatas;
    protected LayoutInflater mInflater;
    public interface OnItemClickLister {
        void onItemClick(View view, int position);
    }

    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public RecommendDicussAdapter(List<RecommendedDiscuss> mDatas, Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public RecommendDicussViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view= mInflater.inflate(R.layout.dynamic_item_discuss_list,parent,false);
        RecommendDicussViewHolder viewHolder= new RecommendDicussViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(RecommendDicussViewHolder holder, int position) {
        RecommendedDiscuss reconmmendDicuss=mDatas.get(position);
        String user_name=reconmmendDicuss.getUser_name();
        String reply_user_name=reconmmendDicuss.getReply_user_name();
//        String all_content = "";
        String content=reconmmendDicuss.getContent();

//        holder.discuss_tv.setText(content);
        MoonUtil.SetDicuss(mContext,holder.discuss_tv,content,user_name,R.color.dynamic_default_text_color,reply_user_name, ImageSpan.ALIGN_BOTTOM);
        setUpItemEvent(holder);
    }

    @Override
    public int getItemCount() {
        if(mDatas.size()>5){
            return 5;
        }else {
            return mDatas.size();
        }

    }
    /**
     * 添加股据到指定位置
     * @param pos 数据添加的位置
     * @param obj 数据
     */
    public  void addData(int pos,RecommendedDiscuss obj){
        mDatas.add(obj);
        notifyItemInserted(pos);
    }

    /**
     * 删除股票到指定位置
     * @param pos
     */
    public void deleteData(int pos){
        mDatas.remove(pos);
        notifyItemRemoved(pos);
    }


    public void updateDate(List<RecommendedDiscuss> mDatas) {
        this.mDatas = mDatas;
        notifyDataSetChanged();
    }
    /**
     * 给item添加监听
     * @param holder
     */
    protected  void setUpItemEvent(final RecommendDicussViewHolder holder){
        if(mOnItemClickLister!=null){
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView,layoutPosition);

                }
            });
        }
    }

}

class RecommendDicussViewHolder extends RecyclerView.ViewHolder{

    TextView discuss_tv;

    public RecommendDicussViewHolder(View itemView) {
        super(itemView);
        discuss_tv=(TextView)itemView.findViewById(R.id.item_dicuss_tv);
    }
}
