package com.yidianling.dynamic.common.net;

import android.content.Context;

import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseCommand;
import com.ydl.ydlcommon.data.http.BaseResponse;
import com.ydl.ydlcommon.data.http.FormatText;
import com.ydl.ydlcommon.utils.NetworkParamsUtils;
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils;
import com.ydl.ydlnet.YDLHttpUtils;
import com.yidianling.dynamic.model.Command;
import com.yidianling.dynamic.model.CommentBean;
import com.yidianling.dynamic.model.ExpertBuild;
import com.yidianling.dynamic.model.Focus;
import com.yidianling.dynamic.model.MemberInfoBean;
import com.yidianling.dynamic.model.PublishTrendResult;
import com.yidianling.dynamic.model.Reply;
import com.yidianling.dynamic.model.TestDetail;
import com.yidianling.dynamic.model.TopicListDataBean;
import com.yidianling.dynamic.model.TrendsDetailInfoBean;
import com.yidianling.dynamic.model.TrendsListBean;
import com.yidianling.dynamic.model.TrendsReplyBean;
import com.yidianling.dynamic.model.ZanResult;
import com.yidianling.dynamic.thank.data.SendThxWithMoney;
import com.yidianling.dynamic.thank.data.ThxData;
import com.yidianling.dynamic.thank.data.ThxListDate;
import com.yidianling.dynamic.thank.data.ZJservice;

import java.io.File;
import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;

/**
 * Created by Jim on 2018/2/5 0005.
 */

public class DynamicApiUtils {

    public static void handleError(Context context, Throwable t) {
        HttpErrorUtils.Companion.handleError(context, t);
    }

    public static Map<String, String> getMaps(List<FormatText> list) {
        return NetworkParamsUtils.getMaps(list);
    }

    public static List<FormatText> getPostList(BaseCommand crq) {
        return NetworkParamsUtils.getPostList(crq);
    }


    // 送感谢 (为了获取相关数据)
    public static Observable<BaseResponse<ThxData>> getThxHeadData(Command.GetThxHeadDate cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getThxHeadData(getMaps(list));
    }


    //获取赞列表
    public static Observable<BaseResponse<ThxListDate>> getZanList(Command.GetZanList cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getZanList(getMaps(list));
    }

    //点赞：动态，回帖，个人主页
    public static Observable<BaseResponse<ZanResult>> zanAction(Command.ZanAction cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).zanAction(getMaps(list));
    }

    //获取社区帖子评论详情
    public static Observable<BaseResponse<TrendsReplyBean>> trendsReplyInfo(Command.TrendsReplyInfo cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).trendsReplyInfo(getMaps(list));
    }

    public static Observable<BaseResponse<Object>> visitCounter(Command.UserAndTrendVisitCmd cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).visitCounter(getMaps(list));
    }

    public static Observable<TrendsListBean> fetchPhpTrendList(Command.TrendListCmd cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).fetchPhpTrendList(getMaps(list));
    }

    public static Observable<BaseAPIResponse<TrendsListBean>> fetchTrendList(Command.TrendListCmd cmd) {
        List<FormatText> list = getPostList(cmd);
        return  YDLHttpUtils.Companion.obtainApi(NetApiStore.class).fetchTrendList(getMaps(list));
    }

    //个人资料
    public static Observable<BaseResponse<MemberInfoBean>> getMemberInfo(Command.MemberInfoCmd cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getMemberInfo(getMaps(list));
    }

    //关注
    public static Observable<BaseResponse<Focus>> focus(Command.FocusCmd cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).focus(getMaps(list));
    }

    //加入黑名单
    public static Observable<BaseResponse<Object>> setBlackCall(Command.SetBlackCall cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).setBlackCall(getMaps(list));
    }

    // 移出黑名单
    public static Observable<BaseResponse<Object>> rmBlack(Command.RmBlack cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).rmBlack(getMaps(list));
    }

    //获取专家相关信息
    public static Observable<BaseResponse<ZJservice>> getService(Command.Service cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getService(getMaps(list));
    }

    //获取举报理由
    public static Observable<BaseResponse> getReportReason(Command.GetReportReason cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getReportReason(getMaps(list));
    }

    //举报心事或者心事回复(动态)
    public static Observable<BaseResponse<Object>> reportWorry(Command.ReportWorry cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).reportWorry(getMaps(list));
    }

    //发布
    // 动态
    public static Observable<BaseResponse<PublishTrendResult>> publishTrend(Command.PublishTrend cmd, File... files) {
        Map<String, RequestBody> map = NetworkParamsUtils.getFileMaps(cmd, "FILE", files);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).publishTrend(map);
    }

    //话题列表
    public static Observable<BaseResponse<TopicListDataBean>> fetchTopicList(Command.AllTopicCmd cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).fetchTopicList(getMaps(list));
    }

    /**
     * 获取用户信息
     */
    public static Observable<BaseResponse<Object>> adClickCount(Command.AdClickCount c) {
        List<FormatText> list = getPostList(c);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).adClickCount(getMaps(list));
    }

    //个人动态
    public static Observable<BaseResponse<List<TrendsListBean.Trend>>> getUserTrend(Command.UserTrendCmd cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getUserTrend(getMaps(list));
    }

    public static Observable<BaseResponse<TestDetail>> fetchTestDetail(Command.FetchTestDetailCommand cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).fetchTestDetail(getMaps(list));
    }

    //获取社区帖子评论列表 todo php 待修改
    public static Observable<BaseResponse<List<CommentBean>>> fetchTrendsComments(Command.TrendsComments cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).fetchTrendsComments(getMaps(list));
    }

    //帖子或评论删除
    public static Observable<BaseResponse<Object>> removeTrendsReply(Command.TrendsReplyDel cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).removeTrendsReply(getMaps(list));
    }

    //私聊 获取聊天者的订单关系数据
    public static Observable<BaseResponse<ExpertBuild>> getExpert(Command.GetExpert cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getExpert(getMaps(list));
    }

    //获取用户的状态（用户、专家、助理）
    public static Observable<BaseAPIResponse<String>> getExpert(String toUid) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getUserType(toUid);
    }

    ////私聊 获取聊天者的订单关系数据   -----进入聊天前调用的接口，采用新的java接口，直接php  getExpert 接口废弃
    public static Observable<BaseResponse<ExpertBuild>> getPersonalChat(String toUid) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getPersonalChat(toUid);
    }

    //回复盖楼
    public static Observable<BaseResponse<Reply>> commitOrReply(Command.CommentOrReply cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).commitOrReply(getMaps(list));
    }

    //话题/动态详情
    public static Observable<BaseAPIResponse<TrendsDetailInfoBean>> fetchTrendsDetailInfo(Command.TrendsInfo cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).fetchTrendsDetailInfo(getMaps(list));
    }

    //感谢表单提交
    public static Observable<BaseResponse<SendThxWithMoney>> submitZan(Command.SubmitZan cmd) {
        List<FormatText> list = getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).submitZan(getMaps(list));
    }
}

